package cn.yoofans.manager.center.api.enums.message;

import java.util.Objects;

/**
 * 用户类型
 * Created by qiuyp
 */
public enum UserTypeEnum {

    ALL_CUSTOMER(1, "全部用户"),
    PURCHASED_CUSTOMER(2, "已购用户"),
    NOT_PURCHASE_CUSTOMER(3, "未购用户"),
    NOT_BEGIN_CLASS(4, "待开课用户"),
    IN_CLASS(5, "上课中用户"),
    IN_CLASS_NO_LISTEN(6, "上课中&当天未听音频用户"),
    IN_CLASS_LISTENING_NO_CLOCK(7, "上课中&当天已听音频&当天未打卡用户");

    /**
     * 代码
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;

    UserTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param code
     * @return
     */
    public static UserTypeEnum getByCode(Integer code) {
        for (UserTypeEnum value : UserTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value;
            }
        }
        return null;
    }

    /**
     * 判断相等
     *
     * @param code
     * @return
     */
    public Boolean equal(Integer code) {
        if (null == code) return Boolean.FALSE;
        if (code.equals(this.getCode())) return Boolean.TRUE;
        return Boolean.FALSE;
    }

    /**
     * 获取描述
     *
     * @param code
     * @return
     */
    public static String getDesc(Integer code) {
        if (null == code) return null;
        for (UserTypeEnum value : UserTypeEnum.values()) {
            if (Objects.equals(code, value.getCode())) {
                return value.getDesc();
            }
        }
        return null;
    }

}
