package cn.yoofans.manager.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.AuthorizerExtDTO;

import java.util.List;

/**
 * 小程序内容关联远程调用Service
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteAuthorizerExtService {

    /**
     * 新增
     *
     * @param dto
     * @return
     */
    public AuthorizerExtDTO insert(AuthorizerExtDTO dto) throws BizException;

    /**
     * 删除详情
     *
     * @param id
     * @return
     */
    public Boolean delete(Long id) throws BizException;

    /**
     * 修改详情
     *
     * @param updateDTO
     * @return
     */
    public Boolean update(AuthorizerExtDTO dto) throws BizException;

    /**
     * 依据Id查询详情
     *
     * @param id
     * @return
     */
    public AuthorizerExtDTO findById(Long id) throws BizException;

    /**
     * 依据authorizerId查询详情
     *
     * @param id
     * @return
     */
    public AuthorizerExtDTO findByAuthorizerId(Long authorizerId) throws BizException;


    /**
     * 按照类型id数组查找
     *
     * @param authorizerTypeIds
     * @return
     */
    List<AuthorizerExtDTO> findByAuthorizerTypeIds(List<Long> authorizerTypeIds);

    /**
     * 依据authorizerId, typeId查询详情
     *
     * @param authorizerId
     * @param typeId
     * @return
     */
    public AuthorizerExtDTO findByAuthorizerIdAndTypeId(Long authorizerId, Long typeId);

    /**
     * 修改加入消息系统标志
     *
     * @param authorizerId
     * @param msgSystemFlag
     * @param userName
     * @return
     */
    Boolean updateMsgSystemFlagByAuthorizerId(Long authorizerId, Integer msgSystemFlag, String userName);

}
