/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteSkinService
 * Author:   amu
 * Date:     2018/3/23 下午4:45
 * Description:
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.manager.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.manager.center.api.dto.SkinDto;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈远程皮肤管理〉
 *
 * @author amu
 * @create 2018/3/23
 * @since 1.0.0
 */
@AdvancedFeignClient
public interface RemoteSkinService {

    /**
     * 按照id查找
     * @param skinId
     * @return
     */
    SkinDto findById(Long skinId);



    /**
     * 插入
     * @param skinDto
     * @return
     */
    SkinDto insert(SkinDto skinDto);


    /**
     * 按照id删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 按照id更新
     * @param skinDto
     * @return
     */

    int updateById(SkinDto skinDto);

    /**
     * 分页查询的数据
     * @param skinName
     * @param pageNum
     * @param pageSize
     * @return
     */
    List<SkinDto> findByPage(String skinName, Integer pageNum , Integer pageSize);

    /**
     * 分页查询的总数
     * @param skinName
     * @return
     */
    Long findByPageCount(String skinName);


    /**
     * 按照名称查找
     * @param skinName
     * @return
     */
    List<SkinDto> findByName(String skinName);
}
