/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: MessageResultDTO
 * Author:   amu
 * Date:     2018/7/11 下午3:30
 * Description: 消息发送返回结果
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.message.api.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * 〈一句话功能简述〉<br>
 * 〈消息发送返回结果〉
 *
 * @author amu
 * @create 2018/7/11
 * @since 1.0.0
 */
public class MessageResultDTO implements Serializable {

    private static final long serialVersionUID = -8512601400277970750L;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 消息id
     */
    private Long messageId;

    /**
     * 错误码
     */
    private String errorcode;

    /**
     * 错误信息
     */
    private String errmsg;

    /**
     * 发送时间
     */
    private String sendTime;

    /**
     * 用户昵称
     */
    private String nickName;

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getMessageId() {
        return messageId;
    }

    public void setMessageId(Long messageId) {
        this.messageId = messageId;
    }

    public String getErrorcode() {
        return errorcode;
    }

    public void setErrorcode(String errorcode) {
        this.errorcode = errorcode;
    }

    public String getErrmsg() {
        return errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public String getSendTime() {
        return sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

}
