/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: SendMsgTypeEnum
 * Author:   amu
 * Date:     2018/7/11 下午8:00
 * Description: 发送消息枚举类型
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.message.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 〈一句话功能简述〉<br> 
 * 〈发送消息枚举类型〉
 *
 * @author amu
 * @create 2018/7/11
 * @since 1.0.0
 */
public enum SendMsgTypeEnum {
    KF_MESSAGE(1,"客服消息"),
    TEMPLATE_MESSAGE(2,"模板消息"),
    SMS_MESSAGE(3,"短信"),
    EMAIL_MESSAGE(4,"邮件");

    private Integer type;

    private String name;

    SendMsgTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    private static Map<Integer, SendMsgTypeEnum> enumMap = Maps.newHashMap();

    static {
        for (SendMsgTypeEnum it : SendMsgTypeEnum.values()) {
            enumMap.put(it.type, it);
        }
    }

    public static SendMsgTypeEnum getEnumByType(Integer Type) {
        return enumMap.get(Type);
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}
