package cn.yoofans.wechat.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.wechat.api.dto.AuthorizerPageDto;
import cn.yoofans.wechat.api.queryparam.AuthorizerQueryParam;
import cn.yoofans.wechat.api.dto.result.AuthorizerQueryResultDto;

import java.util.List;

/**
 * Created by sunyan on 2018/1/19.
 */
@AdvancedFeignClient
public interface RemoteAuthorizerService {

    /**
     * 授权回调
     * @param authCode
     * @throws BizException
     */
    void authorize(String authCode) throws BizException;

    /**
     * 获得授权url
     * @return
     */
    String getAuthorization() throws BizException;

    /**
     * 公众号列表分页查询
     * @param authorizerQueryParam
     * @return
     */
    AuthorizerQueryResultDto authorizerListQuery(AuthorizerQueryParam authorizerQueryParam);

    /**
     * 删除公众号
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 按公众号原始id批量查询（OriginId在第三方叫做username，微信取的好名字0。0）
     * @param userNames
     * @return
     */
    List<AuthorizerPageDto> findByUserNames(List<String> userNames);
}
