/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: RemoteWechatThirdPartyService
 * Author:   amu
 * Date:     2018/7/11 下午2:11
 * Description: 微信第三方服务接口
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.wechat.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.wechat.api.dto.message.WechatUploadBean;

/**
 * 微信上传服务
 *
 * @author qiuyp
 */
@AdvancedFeignClient
public interface RemoteWechatUploadService {

    /**
     * 上传永久素材
     *
     * @param appId     应用id
     * @param fileType  文件类型 图片（image）、语音（voice）、视频（video）和缩略图（thumb）
     * @param fileBytes 文件流字节
     * @param fileName  文件名称
     * @return
     * @throws BizException
     */
    WechatUploadBean addMaterial(String appId, String fileType, byte[] fileBytes, String fileName) throws BizException;
}
