package cn.yoofans.wechat.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.yoofans.wechat.api.dto.MpUserinfoDto;
import cn.yoofans.wechat.api.dto.mq.MpTemplatePushMQDto;
import cn.yoofans.wechat.api.dto.mq.WxJsapiSignatureDto;
import cn.yoofans.wechat.api.dto.template.WxMpTemplateMessage;

/**
 * Created by sunyan on 2018/5/8.
 * 微信公众号相关接口
 */
@AdvancedFeignClient
public interface RemoteMpService {

    WxJsapiSignatureDto getJsapiSignature(String appId, String url);

    /**
     * 发送模板消息
     *
     * @param appId
     * @param message
     */
    void sendMpTemplateMessage(String appId, WxMpTemplateMessage message);

    /**
     * 发送模板数据
     * @param mqDto 公众号模板消息推送参数
     */
    void sendMqMpTemplateMessage(MpTemplatePushMQDto mqDto);

    MpUserinfoDto getUserinfo(String appId, String openid);
}
