/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: WxMpTemplateMessage
 * Author:   amu
 * Date:     2018/5/14 下午3:01
 * Description: 微信公众号模板消息
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package cn.yoofans.wechat.api.dto.template;

import java.io.Serializable;
import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈微信公众号模板消息〉
 *
 * @author amu
 * @create 2018/5/14
 * @since 1.0.0
 */
public class WxMpTemplateMessage implements Serializable{
    private static final long serialVersionUID = -5253892233531606153L;
    private String toUser;
    private String templateId;
    private String url;
    private WxMpTemplateMessage.MiniProgram miniProgram;
    private List<WxMpTemplateData> data;


    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MiniProgram getMiniProgram() {
        return miniProgram;
    }

    public void setMiniProgram(MiniProgram miniProgram) {
        this.miniProgram = miniProgram;
    }

    public List<WxMpTemplateData> getData() {
        return data;
    }

    public void setData(List<WxMpTemplateData> data) {
        this.data = data;
    }

    public static class MiniProgram implements Serializable{
        private static final long serialVersionUID = -9090195167577750162L;
        private String appid;
        private String path;

        public String getAppid() {
            return appid;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public String getPath() {
            return path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public MiniProgram() {
        }

        public MiniProgram(String appid, String path) {
            this.appid = appid;
            this.path = path;
        }
    }

}
