/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.plan.nodes.exec.batch;

import org.apache.flink.table.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecBoundedStreamScan;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecCalc;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecCorrelate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecExchange;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecExpand;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecHashAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecHashJoinBase;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecHashWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLimit;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalHashAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalHashWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalSortAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecLocalSortWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecNestedLoopJoinBase;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecOverAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecRank;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSink;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSort;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSortAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSortLimit;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSortMergeJoinBase;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecSortWindowAggregate;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecTableSourceScan;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecTemporalTableJoin;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecUnion;
import org.apache.flink.table.plan.nodes.physical.batch.BatchExecValues;

/**
 * Visitor pattern for traversing a dag of {@link BatchExecNode} objects. The visit can see the
 * detail type of every node.
 */
public interface BatchExecNodeVisitor {

	//~ visit Methods ----------------------------------------------------------------

	void visit(BatchExecBoundedStreamScan boundedStreamScan);

	void visit(BatchExecTableSourceScan scanTableSource);

	void visit(BatchExecValues values);

	void visit(BatchExecCalc calc);

	void visit(BatchExecCorrelate correlate);

	void visit(BatchExecExchange exchange);

	void visit(BatchExecExpand expand);

	void visit(BatchExecHashAggregate hashAggregate);

	void visit(BatchExecHashWindowAggregate hashAggregate);

	void visit(BatchExecHashJoinBase hashJoin);

	void visit(BatchExecSortMergeJoinBase sortMergeJoin);

	void visit(BatchExecNestedLoopJoinBase nestedLoopJoin);

	void visit(BatchExecLocalHashAggregate localHashAggregate);

	void visit(BatchExecSortAggregate sortAggregate);

	void visit(BatchExecLocalHashWindowAggregate localHashAggregate);

	void visit(BatchExecLocalSortAggregate localSortAggregate);

	void visit(BatchExecLocalSortWindowAggregate localSortAggregate);

	void visit(BatchExecSortWindowAggregate sortAggregate);

	void visit(BatchExecOverAggregate overWindowAgg);

	void visit(BatchExecLimit limit);

	void visit(BatchExecSort sort);

	void visit(BatchExecSortLimit sortLimit);

	void visit(BatchExecRank rank);

	void visit(BatchExecUnion union);

	void visit(BatchExecTemporalTableJoin joinTable);

	void visit(BatchExecSink<?> sink);
}
