/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.flink.table.plan.util

import org.apache.flink.streaming.api.transformations.StreamTransformation
import org.apache.flink.table.api.{TableConfig, TableConfigOptions}
import org.apache.flink.table.plan.nodes.exec.StreamExecNode
import org.apache.flink.table.runtime.{BaseRowKeySelector, BinaryRowKeySelector, NullBinaryRowKeySelector}
import org.apache.flink.table.typeutils.BaseRowTypeInfo

object StreamExecUtil {

  def getKeySelector(
    keyFields: Array[Int],
    rowType: BaseRowTypeInfo): BaseRowKeySelector = {

    if (keyFields.nonEmpty) {
      new BinaryRowKeySelector(keyFields, rowType)
    } else {
      new NullBinaryRowKeySelector
    }
  }

  def setUid(
      tableConfig: TableConfig,
      transformation: StreamTransformation[_],
      physicalNode: StreamExecNode[_]): StreamTransformation[_] = {
    if (tableConfig.getConf.getBoolean(TableConfigOptions.SQL_EXEC_STATE_REUSE)) {
      ExecNodeUidCalculator.getUid(physicalNode).foreach(transformation.setUid)
    }
    transformation
  }
}

