/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.util.Set;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.function.Predicate2;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class EnumerableThetaJoin
extends Join
implements EnumerableRel {
    protected EnumerableThetaJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, variablesSet, joinType);
    }

    @Deprecated
    protected EnumerableThetaJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        this(cluster, traits, left, right, condition, CorrelationId.setOf(variablesStopped), joinType);
    }

    @Override
    public EnumerableThetaJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new EnumerableThetaJoin(this.getCluster(), traitSet, left, right, condition, this.variablesSet, joinType);
        }
        catch (InvalidRelException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        switch (this.joinType) {
            case RIGHT: {
                rowCount = this.addEpsilon(rowCount);
                break;
            }
            default: {
                if (this.left.getId() <= this.right.getId()) break;
                rowCount = this.addEpsilon(rowCount);
            }
        }
        double rightRowCount = this.right.estimateRowCount(mq);
        double leftRowCount = this.left.estimateRowCount(mq);
        if (Double.isInfinite(leftRowCount)) {
            rowCount = leftRowCount;
        }
        if (Double.isInfinite(rightRowCount)) {
            rowCount = rightRowCount;
        }
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    private double addEpsilon(double d) {
        assert (d >= 0.0);
        double d0 = d;
        if (d < 10.0 && (d *= 1.001) != d0) {
            return d;
        }
        if ((d += 1.0) != d0) {
            return d;
        }
        return d *= 1.001;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        BlockBuilder builder2 = new BlockBuilder();
        return implementor.result(physType, builder.append(Expressions.call(BuiltInMethod.THETA_JOIN.method, leftExpression, rightExpression, this.predicate(implementor, builder2, leftResult.physType, rightResult.physType, this.condition), EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType)), Expressions.constant(this.joinType.generatesNullsOnLeft()), Expressions.constant(this.joinType.generatesNullsOnRight()))).toBlock());
    }

    Expression predicate(EnumerableRelImplementor implementor, BlockBuilder builder, PhysType leftPhysType, PhysType rightPhysType, RexNode condition) {
        ParameterExpression left_ = Expressions.parameter(leftPhysType.getJavaRowType(), "left");
        ParameterExpression right_ = Expressions.parameter(rightPhysType.getJavaRowType(), "right");
        RexProgramBuilder program = new RexProgramBuilder(((RelDataTypeFactory.FieldInfoBuilder)implementor.getTypeFactory().builder().addAll(this.left.getRowType().getFieldList())).addAll(this.right.getRowType().getFieldList()).build(), this.getCluster().getRexBuilder());
        program.addCondition(condition);
        builder.add(Expressions.return_(null, RexToLixTranslator.translateCondition(program.getProgram(), implementor.getTypeFactory(), builder, new RexToLixTranslator.InputGetterImpl(ImmutableList.of(Pair.of(left_, leftPhysType), Pair.of(right_, rightPhysType))), implementor.allCorrelateVariables)));
        return Expressions.lambda(Predicate2.class, builder.toBlock(), left_, right_);
    }
}

