/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.flink.shaded.calcite.com.google.common.collect.Iterables;
import org.apache.flink.shaded.calcite.com.google.common.collect.Ordering;

public class SortNode
extends AbstractSingleNode<Sort> {
    public SortNode(Compiler compiler, Sort rel) {
        super(compiler, rel);
    }

    @Override
    public void run() throws InterruptedException {
        block10: {
            int fetch;
            int offset = ((Sort)this.rel).offset == null ? 0 : ((RexLiteral)((Sort)this.rel).offset).getValueAs(Integer.class);
            int n = fetch = ((Sort)this.rel).fetch == null ? -1 : ((RexLiteral)((Sort)this.rel).fetch).getValueAs(Integer.class);
            if (((Sort)this.rel).getCollation().getFieldCollations().isEmpty()) {
                Row row2;
                int i;
                for (i = 0; i < offset; ++i) {
                    row2 = this.source.receive();
                    if (row2 != null) {
                        continue;
                    }
                    break block10;
                }
                if (fetch >= 0) {
                    for (i = 0; i < fetch && (row2 = this.source.receive()) != null; ++i) {
                        this.sink.send(row2);
                    }
                } else {
                    while ((row2 = this.source.receive()) != null) {
                        this.sink.send(row2);
                    }
                }
            } else {
                Row row3;
                ArrayList<Row> list = new ArrayList<Row>();
                while ((row3 = this.source.receive()) != null) {
                    list.add(row3);
                }
                list.sort(this.comparator());
                int end = fetch < 0 || offset + fetch > list.size() ? list.size() : offset + fetch;
                for (int i = offset; i < end; ++i) {
                    this.sink.send((Row)list.get(i));
                }
            }
        }
        this.sink.end();
    }

    private Comparator<Row> comparator() {
        if (((Sort)this.rel).getCollation().getFieldCollations().size() == 1) {
            return this.comparator(((Sort)this.rel).getCollation().getFieldCollations().get(0));
        }
        return Ordering.compound(Iterables.transform(((Sort)this.rel).getCollation().getFieldCollations(), this::comparator));
    }

    private Comparator<Row> comparator(RelFieldCollation fieldCollation) {
        int nullComparison = fieldCollation.nullDirection.nullComparison;
        int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return (o1, o2) -> {
                    Comparable c1 = (Comparable)o1.getValues()[x];
                    Comparable c2 = (Comparable)o2.getValues()[x];
                    return RelFieldCollation.compare(c1, c2, nullComparison);
                };
            }
        }
        return (o1, o2) -> {
            Comparable c1 = (Comparable)o1.getValues()[x];
            Comparable c2 = (Comparable)o2.getValues()[x];
            return RelFieldCollation.compare(c2, c1, -nullComparison);
        };
    }
}

