/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.logical.LogicalExchange;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMatch;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

class CalciteMaterializer
extends CalcitePrepareImpl.CalcitePreparingStmt {
    CalciteMaterializer(CalcitePrepareImpl prepare, CalcitePrepare.Context context, Prepare.CatalogReader catalogReader, CalciteSchema schema2, RelOptPlanner planner, SqlRexConvertletTable convertletTable) {
        super(prepare, context, catalogReader, catalogReader.getTypeFactory(), schema2, EnumerableRel.Prefer.ANY, planner, BindableConvention.INSTANCE, convertletTable);
    }

    void populate(Prepare.Materialization materialization) {
        SqlNode node;
        SqlParser parser = SqlParser.create(materialization.sql);
        try {
            node = parser.parseStmt();
        }
        catch (SqlParseException e2) {
            throw new RuntimeException("parse failed", e2);
        }
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(true).build();
        SqlToRelConverter sqlToRelConverter2 = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader, config);
        materialization.queryRel = sqlToRelConverter2.convertQuery((SqlNode)node, (boolean)true, (boolean)true).rel;
        this.useStar(this.schema, materialization);
        SqlValidatorTable table = this.catalogReader.getTable((List)materialization.materializedTable.path());
        materialization.tableRel = sqlToRelConverter2.toRel((RelOptTable)((Object)table));
    }

    private void useStar(CalciteSchema schema2, Prepare.Materialization materialization) {
        for (Callback x : this.useStar(schema2, materialization.queryRel)) {
            materialization.materialize(x.rel, x.starRelOptTable);
            if (!CalcitePrepareImpl.DEBUG) continue;
            System.out.println("Materialization " + materialization.materializedTable + " matched star table " + x.starTable + "; query after re-write: " + RelOptUtil.toString(materialization.queryRel));
        }
    }

    private Iterable<Callback> useStar(CalciteSchema schema2, RelNode queryRel) {
        List<CalciteSchema.TableEntry> starTables = Schemas.getStarTables(schema2.root());
        if (starTables.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Callback> list = new ArrayList<Callback>();
        RelNode rel2 = RelOptMaterialization.toLeafJoinForm(queryRel);
        for (CalciteSchema.TableEntry starTable : starTables) {
            Table table = starTable.getTable();
            assert (table instanceof StarTable);
            RelOptTableImpl starRelOptTable = RelOptTableImpl.create((RelOptSchema)this.catalogReader, table.getRowType(this.typeFactory), starTable, null);
            RelNode rel3 = RelOptMaterialization.tryUseStar(rel2, starRelOptTable);
            if (rel3 == null) continue;
            list.add(new Callback(rel3, starTable, starRelOptTable));
        }
        return list;
    }

    static class Callback {
        public final RelNode rel;
        public final CalciteSchema.TableEntry starTable;
        public final RelOptTableImpl starRelOptTable;

        Callback(RelNode rel, CalciteSchema.TableEntry starTable, RelOptTableImpl starRelOptTable) {
            this.rel = rel;
            this.starTable = starTable;
            this.starRelOptTable = starRelOptTable;
        }
    }

    static class RelNullShuttle
    implements RelShuttle {
        RelNullShuttle() {
        }

        @Override
        public RelNode visit(TableScan scan) {
            return scan;
        }

        @Override
        public RelNode visit(TableFunctionScan scan) {
            return scan;
        }

        @Override
        public RelNode visit(LogicalValues values) {
            return values;
        }

        @Override
        public RelNode visit(LogicalFilter filter) {
            return filter;
        }

        @Override
        public RelNode visit(LogicalProject project) {
            return project;
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            return join;
        }

        @Override
        public RelNode visit(LogicalCorrelate correlate) {
            return correlate;
        }

        @Override
        public RelNode visit(LogicalUnion union) {
            return union;
        }

        @Override
        public RelNode visit(LogicalIntersect intersect) {
            return intersect;
        }

        @Override
        public RelNode visit(LogicalMinus minus2) {
            return minus2;
        }

        @Override
        public RelNode visit(LogicalAggregate aggregate) {
            return aggregate;
        }

        @Override
        public RelNode visit(LogicalMatch match) {
            return match;
        }

        @Override
        public RelNode visit(LogicalSort sort) {
            return sort;
        }

        @Override
        public RelNode visit(LogicalExchange exchange) {
            return exchange;
        }

        @Override
        public RelNode visit(RelNode other) {
            return other;
        }
    }
}

