/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.stream;

import java.util.ArrayList;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.stream.Delta;
import org.apache.calcite.rel.stream.LogicalDelta;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class StreamRules {
    public static final ImmutableList<RelOptRule> RULES = ImmutableList.of(new DeltaProjectTransposeRule(RelFactories.LOGICAL_BUILDER), new DeltaFilterTransposeRule(RelFactories.LOGICAL_BUILDER), new DeltaAggregateTransposeRule(RelFactories.LOGICAL_BUILDER), new DeltaSortTransposeRule(RelFactories.LOGICAL_BUILDER), new DeltaUnionTransposeRule(RelFactories.LOGICAL_BUILDER), new DeltaJoinTransposeRule(RelFactories.LOGICAL_BUILDER), new DeltaTableScanRule(RelFactories.LOGICAL_BUILDER), new DeltaTableScanToEmptyRule(RelFactories.LOGICAL_BUILDER));

    private StreamRules() {
    }

    public static class DeltaJoinTransposeRule
    extends RelOptRule {
        @Deprecated
        public DeltaJoinTransposeRule() {
            this(RelFactories.LOGICAL_BUILDER);
        }

        public DeltaJoinTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaJoinTransposeRule.operand(Delta.class, DeltaJoinTransposeRule.operand(Join.class, DeltaJoinTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Join join = (Join)call.rel(1);
            RelNode left = join.getLeft();
            RelNode right = join.getRight();
            LogicalDelta rightWithDelta = LogicalDelta.create(right);
            LogicalJoin joinL = LogicalJoin.create(left, (RelNode)rightWithDelta, join.getCondition(), join.getVariablesSet(), join.getJoinType(), join.isSemiJoinDone(), ImmutableList.copyOf(join.getSystemFieldList()));
            LogicalDelta leftWithDelta = LogicalDelta.create(left);
            LogicalJoin joinR = LogicalJoin.create((RelNode)leftWithDelta, right, join.getCondition(), join.getVariablesSet(), join.getJoinType(), join.isSemiJoinDone(), ImmutableList.copyOf(join.getSystemFieldList()));
            ArrayList<RelNode> inputsToUnion = new ArrayList<RelNode>();
            inputsToUnion.add(joinL);
            inputsToUnion.add(joinR);
            LogicalUnion newNode = LogicalUnion.create(inputsToUnion, true);
            call.transformTo(newNode);
        }
    }

    public static class DeltaTableScanToEmptyRule
    extends RelOptRule {
        public DeltaTableScanToEmptyRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaTableScanToEmptyRule.operand(Delta.class, DeltaTableScanToEmptyRule.operand(TableScan.class, DeltaTableScanToEmptyRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            RelOptTable relOptTable = scan.getTable();
            StreamableTable streamableTable = relOptTable.unwrap(StreamableTable.class);
            RelBuilder builder = call.builder();
            if (streamableTable == null) {
                call.transformTo(builder.values(delta.getRowType()).build());
            }
        }
    }

    public static class DeltaTableScanRule
    extends RelOptRule {
        public DeltaTableScanRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaTableScanRule.operand(Delta.class, DeltaTableScanRule.operand(TableScan.class, DeltaTableScanRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            RelOptCluster cluster = delta.getCluster();
            RelOptTable relOptTable = scan.getTable();
            StreamableTable streamableTable = relOptTable.unwrap(StreamableTable.class);
            if (streamableTable != null) {
                Table table1 = streamableTable.stream();
                RelOptTableImpl relOptTable2 = RelOptTableImpl.create(relOptTable.getRelOptSchema(), relOptTable.getRowType(), table1, (ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(relOptTable.getQualifiedName())).add("(STREAM)")).build());
                LogicalTableScan newScan = LogicalTableScan.create(cluster, relOptTable2);
                call.transformTo(newScan);
            }
        }
    }

    public static class DeltaUnionTransposeRule
    extends RelOptRule {
        public DeltaUnionTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaUnionTransposeRule.operand(Delta.class, DeltaUnionTransposeRule.operand(Union.class, DeltaUnionTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Union union = (Union)call.rel(1);
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : union.getInputs()) {
                LogicalDelta newDelta = LogicalDelta.create(input);
                newInputs.add(newDelta);
            }
            LogicalUnion newUnion = LogicalUnion.create(newInputs, union.all);
            call.transformTo(newUnion);
        }
    }

    public static class DeltaSortTransposeRule
    extends RelOptRule {
        public DeltaSortTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaSortTransposeRule.operand(Delta.class, DeltaSortTransposeRule.operand(Sort.class, DeltaSortTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Sort sort = (Sort)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(sort.getInput());
            LogicalSort newSort = LogicalSort.create(newDelta, sort.collation, sort.offset, sort.fetch);
            call.transformTo(newSort);
        }
    }

    public static class DeltaAggregateTransposeRule
    extends RelOptRule {
        public DeltaAggregateTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaAggregateTransposeRule.operand(Delta.class, DeltaAggregateTransposeRule.operandJ(Aggregate.class, null, Aggregate::noIndicator, DeltaAggregateTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Aggregate aggregate = (Aggregate)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(aggregate.getInput());
            LogicalAggregate newAggregate = LogicalAggregate.create(newDelta, aggregate.getGroupSet(), aggregate.groupSets, aggregate.getAggCallList());
            call.transformTo(newAggregate);
        }
    }

    public static class DeltaFilterTransposeRule
    extends RelOptRule {
        public DeltaFilterTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaFilterTransposeRule.operand(Delta.class, DeltaFilterTransposeRule.operand(Filter.class, DeltaFilterTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Filter filter = (Filter)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(filter.getInput());
            LogicalFilter newFilter = LogicalFilter.create(newDelta, filter.getCondition());
            call.transformTo(newFilter);
        }
    }

    public static class DeltaProjectTransposeRule
    extends RelOptRule {
        public DeltaProjectTransposeRule(RelBuilderFactory relBuilderFactory) {
            super(DeltaProjectTransposeRule.operand(Delta.class, DeltaProjectTransposeRule.operand(Project.class, DeltaProjectTransposeRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Delta delta = (Delta)call.rel(0);
            Util.discard(delta);
            Project project = (Project)call.rel(1);
            LogicalDelta newDelta = LogicalDelta.create(project.getInput());
            LogicalProject newProject = LogicalProject.create((RelNode)newDelta, project.getProjects(), project.getRowType().getFieldNames());
            call.transformTo(newProject);
        }
    }
}

