/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class SqlEmit
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("EMIT", SqlKind.EMIT);
    static final SqlPostfixOperator BEFORE_COMPLETE_OPERATOR = new SqlPostfixOperator("BEFORE COMPLETE", SqlKind.PRECEDING, 20, ReturnTypes.ARG0, null, null);
    static final SqlPostfixOperator AFTER_COMPLETE_OPERATOR = new SqlPostfixOperator("AFTER COMPLETE", SqlKind.FOLLOWING, 20, ReturnTypes.ARG0, null, null);
    SqlNode beforeDelay;
    SqlNode afterDelay;

    public SqlEmit(SqlParserPos pos, SqlNode beforeDelay, SqlNode afterDelay) {
        super(pos);
        this.beforeDelay = beforeDelay;
        this.afterDelay = afterDelay;
    }

    public long getBeforeDelayValue() {
        return this.getDelayValue(this.beforeDelay);
    }

    public long getAfterDelayValue() {
        return this.getDelayValue(this.afterDelay);
    }

    public SqlNode getBeforeDelay() {
        return this.beforeDelay;
    }

    public SqlNode getAfterDelay() {
        return this.afterDelay;
    }

    private long getDelayValue(SqlNode delay) {
        if (delay == null) {
            return Long.MIN_VALUE;
        }
        if (SqlEmit.isWithoutDelay(delay)) {
            return 0L;
        }
        return ((SqlLiteral)delay).getValueAs(BigDecimal.class).longValue();
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.beforeDelay, this.afterDelay);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.newlineAndIndent();
        writer.keyword("EMIT");
        writer.newlineAndIndent();
        if (this.beforeDelay != null) {
            this.unparse(this.beforeDelay, writer);
            writer.keyword("BEFORE WATERMARK");
        }
        if (this.afterDelay != null) {
            if (this.beforeDelay != null) {
                writer.print(",");
                writer.newlineAndIndent();
            }
            this.unparse(this.afterDelay, writer);
            writer.keyword("AFTER WATERMARK");
        }
    }

    private void unparse(SqlNode delay, SqlWriter writer) {
        if (SqlEmit.isWithoutDelay(delay)) {
            delay.unparse(writer, 0, 0);
        } else {
            writer.keyword("WITH DELAY");
            SqlIntervalLiteral interval = (SqlIntervalLiteral)delay;
            SqlIntervalLiteral.IntervalValue value = (SqlIntervalLiteral.IntervalValue)interval.getValue();
            writer.literal("'" + value.getIntervalLiteral() + "'");
            writer.keyword(value.getIntervalQualifier().toString());
        }
    }

    public static SqlEmit create(SqlParserPos pos, List<SqlNode> strategies) {
        SqlNode beforeDelay = null;
        SqlNode afterDelay = null;
        for (SqlNode s : strategies) {
            if (SqlKind.PRECEDING == s.getKind() && beforeDelay == null) {
                beforeDelay = ((SqlCall)s).getOperandList().get(0);
                continue;
            }
            if (SqlKind.FOLLOWING == s.getKind() && afterDelay == null) {
                afterDelay = ((SqlCall)s).getOperandList().get(0);
                continue;
            }
            throw new RuntimeException("Sql Emit statement shouldn't contain duplicate strategies");
        }
        return new SqlEmit(pos, beforeDelay, afterDelay);
    }

    public static SqlNode createWithoutDelay(SqlParserPos pos) {
        return Delay.WITHOUT_DELAY.symbol(pos);
    }

    public static SqlNode createAfterStrategy(SqlNode delay, SqlParserPos pos) {
        return AFTER_COMPLETE_OPERATOR.createCall(pos, delay);
    }

    public static SqlNode createBeforeStrategy(SqlNode delay, SqlParserPos pos) {
        return BEFORE_COMPLETE_OPERATOR.createCall(pos, delay);
    }

    public static boolean isWithoutDelay(SqlNode node) {
        SqlLiteral literal;
        if (node instanceof SqlLiteral && (literal = (SqlLiteral)node).getTypeName() == SqlTypeName.SYMBOL) {
            return literal.symbolValue(Delay.class) == Delay.WITHOUT_DELAY;
        }
        return false;
    }

    static enum Delay {
        WITHOUT_DELAY("WITHOUT DELAY");

        private final String sql;

        private Delay(String sql) {
            this.sql = sql;
        }

        public String toString() {
            return this.sql;
        }

        public SqlNode symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

