/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParserPos;

public final class Span {
    private final List<SqlParserPos> posList = new ArrayList<SqlParserPos>();

    private Span() {
    }

    public static Span of() {
        return new Span();
    }

    public static Span of(SqlParserPos p) {
        return new Span().add(p);
    }

    public static Span of(SqlNode n) {
        return new Span().add(n);
    }

    public static Span of(SqlNode n0, SqlNode n1) {
        return new Span().add(n0).add(n1);
    }

    public static Span of(Collection<? extends SqlNode> nodes) {
        return new Span().addAll(nodes);
    }

    public Span add(SqlNode n) {
        return this.add(n.getParserPosition());
    }

    public Span addIf(SqlNode n) {
        return n == null ? this : this.add(n);
    }

    public Span add(SqlParserPos pos) {
        this.posList.add(pos);
        return this;
    }

    public Span addAll(Iterable<? extends SqlNode> nodes) {
        for (SqlNode sqlNode : nodes) {
            this.add(sqlNode);
        }
        return this;
    }

    public Span add(SqlAbstractParserImpl parser) {
        try {
            SqlParserPos pos = parser.getPos();
            return this.add(pos);
        }
        catch (Exception e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public SqlParserPos pos() {
        switch (this.posList.size()) {
            case 0: {
                throw new AssertionError();
            }
            case 1: {
                return this.posList.get(0);
            }
        }
        return SqlParserPos.sum(this.posList);
    }

    public SqlParserPos end(SqlAbstractParserImpl parser) {
        return this.add(parser).pos();
    }

    public SqlParserPos end(SqlNode n) {
        return this.add(n).pos();
    }

    public Span clear() {
        this.posList.clear();
        return this;
    }
}

