/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions;

import java.util.Objects;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.util.MathUtils;

public class HashPartitioner<T>
implements Partitioner<T> {
    private static final long serialVersionUID = 1L;
    public static final HashPartitioner<Object> INSTANCE = new HashPartitioner();

    @Override
    public int partition(T key, int numPartitions) {
        return MathUtils.murmurHash(Objects.hashCode(key)) % numPartitions;
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return "HashPartitioner".hashCode();
    }

    public String toString() {
        return "HashPartitioner";
    }
}

