/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions;

import java.util.Map;
import java.util.SortedMap;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.util.Preconditions;

public final class SortedMapMerger<K, V>
implements Merger<SortedMap<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Merger<V> valueMerger;

    public SortedMapMerger(Merger<V> valueMerger) {
        Preconditions.checkNotNull(valueMerger);
        this.valueMerger = valueMerger;
    }

    public Merger<V> getValueMerger() {
        return this.valueMerger;
    }

    @Override
    public SortedMap<K, V> merge(SortedMap<K, V> map1, SortedMap<K, V> map2) {
        Preconditions.checkNotNull(map1);
        Preconditions.checkNotNull(map2);
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            Object oldValue = map1.get(entry.getKey());
            if (oldValue == null) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            V newValue = this.valueMerger.merge(oldValue, entry.getValue());
            map1.put(entry.getKey(), newValue);
        }
        return map1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedMapMerger mapMerger = (SortedMapMerger)o;
        return this.valueMerger.equals(mapMerger.valueMerger);
    }

    public int hashCode() {
        return this.valueMerger.hashCode();
    }

    public String toString() {
        return "SortedMapMerger{valueMerger=" + this.valueMerger + "}";
    }
}

