/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.DataCorruptionException;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.api.common.io.blockcompression.NoCopyByteArrayOutputStream;

public class Bzip2BlockCompressor
extends AbstractBlockCompressor {
    private NoCopyByteArrayOutputStream dstStream;

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return srcSize + 64;
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws DataCorruptionException {
        try {
            if (this.dstStream == null) {
                this.dstStream = new NoCopyByteArrayOutputStream(dst, dstOff);
            } else {
                this.dstStream.reuse(dst, dstOff);
            }
            BZip2CompressorOutputStream compressStream = new BZip2CompressorOutputStream((OutputStream)this.dstStream, BZip2CompressorOutputStream.chooseBlockSize((long)srcLen));
            compressStream.write(src, srcOff, srcLen);
            compressStream.close();
            int compressedLen = this.dstStream.getNumBytesWritten();
            this.dstStream.close();
            if (compressedLen > dst.length - dstOff) {
                throw new InsufficientBufferException("destination buffer remains " + (dst.length - dstOff) + " bytes, requires " + compressedLen + " bytes.");
            }
            return compressedLen;
        }
        catch (IOException e2) {
            throw new DataCorruptionException(e2);
        }
    }
}

