/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.DataCorruptionException;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.api.common.io.blockcompression.NoCopyByteArrayOutputStream;

public class GzipBlockCompressor
extends AbstractBlockCompressor {
    private NoCopyByteArrayOutputStream dstStream;

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return srcSize + 64;
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) {
        try {
            if (this.dstStream == null) {
                this.dstStream = new NoCopyByteArrayOutputStream(dst, dstOff);
            } else {
                this.dstStream.reuse(dst, dstOff);
            }
            GzipCompressorOutputStream compressStream = new GzipCompressorOutputStream((OutputStream)this.dstStream);
            compressStream.write(src, srcOff, srcLen);
            compressStream.close();
            int compressedLen = this.dstStream.getNumBytesWritten();
            this.dstStream.close();
            if (compressedLen > dst.length - dstOff) {
                throw new InsufficientBufferException("destination buffer remains " + (dst.length - dstOff) + " bytes, requires " + compressedLen + " bytes.");
            }
            return compressedLen;
        }
        catch (IOException e2) {
            throw new DataCorruptionException(e2);
        }
    }
}

