/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockCompressor;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;

public class Lz4BlockCompressor
extends AbstractBlockCompressor {
    private final LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();

    @Override
    public int getMaxCompressedSize(int srcSize) {
        return 8 + this.compressor.maxCompressedLength(srcSize);
    }

    @Override
    public int compress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dst, int dstOff) throws InsufficientBufferException {
        try {
            int prevSrcOff = src.position() + srcOff;
            int prevDstOff = dst.position() + dstOff;
            int maxCompressedSize = this.compressor.maxCompressedLength(srcLen);
            int compressedLength = this.compressor.compress(src, prevSrcOff, srcLen, dst, prevDstOff + 8, maxCompressedSize);
            src.position(prevSrcOff + srcLen);
            dst.position(prevDstOff);
            dst.putInt(compressedLength);
            dst.putInt(srcLen);
            dst.position(prevDstOff + compressedLength + 8);
            return 8 + compressedLength;
        }
        catch (LZ4Exception e2) {
            throw new InsufficientBufferException(e2);
        }
        catch (BufferOverflowException e3) {
            throw new InsufficientBufferException(e3);
        }
        catch (ArrayIndexOutOfBoundsException e4) {
            throw new InsufficientBufferException(e4);
        }
    }

    @Override
    public int compress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws InsufficientBufferException {
        try {
            int compressedLength = this.compressor.compress(src, srcOff, srcLen, dst, dstOff + 8);
            Lz4BlockCompressor.writeIntLE(compressedLength, dst, dstOff);
            Lz4BlockCompressor.writeIntLE(srcLen, dst, dstOff + 4);
            return 8 + compressedLength;
        }
        catch (LZ4Exception e2) {
            throw new InsufficientBufferException(e2);
        }
        catch (BufferOverflowException e3) {
            throw new InsufficientBufferException(e3);
        }
        catch (ArrayIndexOutOfBoundsException e4) {
            throw new InsufficientBufferException(e4);
        }
    }

    private static void writeIntLE(int i, byte[] buf, int off) {
        buf[off++] = (byte)i;
        buf[off++] = (byte)(i >>> 8);
        buf[off++] = (byte)(i >>> 16);
        buf[off++] = (byte)(i >>> 24);
    }
}

