/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import org.apache.flink.api.common.operators.ResourceConstraints;
import org.apache.flink.api.common.operators.StrictlyMatchingResourceConstraints;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

public class ResourceConstraintsConfig {
    private final ResourceConstraints defaultConstraints;

    public ResourceConstraintsConfig(Configuration flinkConf) {
        Preconditions.checkNotNull(flinkConf);
        StrictlyMatchingResourceConstraints constraints = new StrictlyMatchingResourceConstraints();
        for (String key : flinkConf.keySet()) {
            if (!key.startsWith("blink.resource.constraint.")) continue;
            constraints.addConstraint(key, flinkConf.getString(key, null));
        }
        this.defaultConstraints = constraints.getConstraints().size() > 0 ? constraints : null;
    }

    public ResourceConstraints getDefaultResourceConstraints() {
        return this.defaultConstraints;
    }
}

