/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.StateBinder;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class AggregatingStateDescriptor<IN, ACC, OUT>
extends StateDescriptor<AggregatingState<IN, OUT>, ACC> {
    private static final long serialVersionUID = 1L;
    private final AggregateFunction<IN, ACC, OUT> aggFunction;

    public AggregatingStateDescriptor(String name, AggregateFunction<IN, ACC, OUT> aggFunction, Class<ACC> stateType) {
        super(name, stateType, null);
        this.aggFunction = Preconditions.checkNotNull(aggFunction);
    }

    public AggregatingStateDescriptor(String name, AggregateFunction<IN, ACC, OUT> aggFunction, TypeInformation<ACC> stateType) {
        super(name, stateType, null);
        this.aggFunction = Preconditions.checkNotNull(aggFunction);
    }

    public AggregatingStateDescriptor(String name, AggregateFunction<IN, ACC, OUT> aggFunction, TypeSerializer<ACC> typeSerializer) {
        super(name, typeSerializer, null);
        this.aggFunction = Preconditions.checkNotNull(aggFunction);
    }

    @Override
    public AggregatingState<IN, OUT> bind(StateBinder stateBinder) throws Exception {
        return stateBinder.createAggregatingState(this);
    }

    public AggregateFunction<IN, ACC, OUT> getAggregateFunction() {
        return this.aggFunction;
    }

    @Override
    public StateDescriptor.Type getType() {
        return StateDescriptor.Type.AGGREGATING;
    }
}

