/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class GenericTypeSerializerConfigSnapshot<T>
extends TypeSerializerConfigSnapshot {
    private Class<T> typeClass;

    public GenericTypeSerializerConfigSnapshot() {
    }

    public GenericTypeSerializerConfigSnapshot(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeUTF(this.typeClass.getName());
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        String genericTypeClassname = in.readUTF();
        try {
            this.typeClass = Class.forName(genericTypeClassname, true, this.getUserCodeClassLoader());
        }
        catch (ClassNotFoundException e2) {
            throw new IOException("Could not find the requested class " + genericTypeClassname + " in classpath.", e2);
        }
    }

    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass().equals(this.getClass()) && this.typeClass.equals(((GenericTypeSerializerConfigSnapshot)obj).getTypeClass());
    }

    @Override
    public int hashCode() {
        return this.typeClass.hashCode();
    }
}

