/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class ParameterlessTypeSerializerConfig
extends TypeSerializerConfigSnapshot {
    private static final int VERSION = 1;
    private String serializationFormatIdentifier;

    public ParameterlessTypeSerializerConfig() {
    }

    public ParameterlessTypeSerializerConfig(String serializationFormatIdentifier) {
        this.serializationFormatIdentifier = Preconditions.checkNotNull(serializationFormatIdentifier);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeUTF(this.serializationFormatIdentifier);
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.serializationFormatIdentifier = in.readUTF();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String getSerializationFormatIdentifier() {
        return this.serializationFormatIdentifier;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other instanceof ParameterlessTypeSerializerConfig && this.serializationFormatIdentifier.equals(((ParameterlessTypeSerializerConfig)other).getSerializationFormatIdentifier());
    }

    @Override
    public int hashCode() {
        return this.serializationFormatIdentifier.hashCode();
    }
}

