/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class GenericArraySerializerConfigSnapshot<C>
extends CompositeTypeSerializerConfigSnapshot {
    private static final int VERSION = 1;
    private Class<C> componentClass;

    public GenericArraySerializerConfigSnapshot() {
    }

    public GenericArraySerializerConfigSnapshot(Class<C> componentClass, TypeSerializer<C> componentSerializer) {
        super(componentSerializer);
        this.componentClass = Preconditions.checkNotNull(componentClass);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        try (DataOutputViewStream outViewWrapper = new DataOutputViewStream(out);){
            InstantiationUtil.serializeObject(outViewWrapper, this.componentClass);
        }
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
            this.componentClass = (Class)InstantiationUtil.deserializeObject(inViewWrapper, this.getUserCodeClassLoader());
        }
        catch (ClassNotFoundException e2) {
            throw new IOException("Could not find requested element class in classpath.", e2);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof GenericArraySerializerConfigSnapshot && this.componentClass.equals(((GenericArraySerializerConfigSnapshot)obj).getComponentClass());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.componentClass.hashCode();
    }
}

