/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializerConfigSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class MapSerializer<K, V>
extends TypeSerializer<Map<K, V>> {
    private static final long serialVersionUID = -6885593032367050078L;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;

    public MapSerializer(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        this.keySerializer = Preconditions.checkNotNull(keySerializer, "The key serializer cannot be null");
        this.valueSerializer = Preconditions.checkNotNull(valueSerializer, "The value serializer cannot be null.");
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Map<K, V>> duplicate() {
        TypeSerializer<K> duplicateKeySerializer = this.keySerializer.duplicate();
        TypeSerializer<V> duplicateValueSerializer = this.valueSerializer.duplicate();
        return duplicateKeySerializer == this.keySerializer && duplicateValueSerializer == this.valueSerializer ? this : new MapSerializer<K, V>(duplicateKeySerializer, duplicateValueSerializer);
    }

    @Override
    public Map<K, V> createInstance() {
        return new HashMap();
    }

    @Override
    public Map<K, V> copy(Map<K, V> from) {
        HashMap<K, Object> newMap = new HashMap<K, Object>(from.size());
        for (Map.Entry<K, V> entry : from.entrySet()) {
            K newKey = this.keySerializer.copy(entry.getKey());
            Object newValue = entry.getValue() == null ? null : (Object)this.valueSerializer.copy(entry.getValue());
            newMap.put(newKey, newValue);
        }
        return newMap;
    }

    @Override
    public Map<K, V> copy(Map<K, V> from, Map<K, V> reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(Map<K, V> map2, DataOutputView target) throws IOException {
        int size = map2.size();
        target.writeInt(size);
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.keySerializer.serialize(entry.getKey(), target);
            if (entry.getValue() == null) {
                target.writeBoolean(true);
                continue;
            }
            target.writeBoolean(false);
            this.valueSerializer.serialize(entry.getValue(), target);
        }
    }

    @Override
    public Map<K, V> deserialize(DataInputView source) throws IOException {
        int size = source.readInt();
        HashMap<K, Object> map2 = new HashMap<K, Object>(size);
        for (int i = 0; i < size; ++i) {
            K key = this.keySerializer.deserialize(source);
            boolean isNull = source.readBoolean();
            Object value = isNull ? null : (Object)this.valueSerializer.deserialize(source);
            map2.put(key, value);
        }
        return map2;
    }

    @Override
    public Map<K, V> deserialize(Map<K, V> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int size = source.readInt();
        target.writeInt(size);
        for (int i = 0; i < size; ++i) {
            this.keySerializer.copy(source, target);
            boolean isNull = source.readBoolean();
            target.writeBoolean(isNull);
            if (isNull) continue;
            this.valueSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.keySerializer.equals(((MapSerializer)obj).getKeySerializer()) && this.valueSerializer.equals(((MapSerializer)obj).getValueSerializer());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    @Override
    public int hashCode() {
        return this.keySerializer.hashCode() * 31 + this.valueSerializer.hashCode();
    }

    @Override
    public MapSerializerConfigSnapshot snapshotConfiguration() {
        return new MapSerializerConfigSnapshot<K, V>(this.keySerializer, this.valueSerializer);
    }

    @Override
    public CompatibilityResult<Map<K, V>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof MapSerializerConfigSnapshot) {
            List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousKvSerializersAndConfigs = ((MapSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
            CompatibilityResult<K> keyCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousKvSerializersAndConfigs.get((int)0).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousKvSerializersAndConfigs.get((int)0).f1, this.keySerializer);
            CompatibilityResult<V> valueCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousKvSerializersAndConfigs.get((int)1).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousKvSerializersAndConfigs.get((int)1).f1, this.valueSerializer);
            if (!keyCompatResult.isRequiresMigration() && !valueCompatResult.isRequiresMigration()) {
                return CompatibilityResult.compatible();
            }
            if (keyCompatResult.getConvertDeserializer() != null && valueCompatResult.getConvertDeserializer() != null) {
                return CompatibilityResult.requiresMigration(new MapSerializer<K, V>(new TypeDeserializerAdapter<K>(keyCompatResult.getConvertDeserializer()), new TypeDeserializerAdapter<V>(valueCompatResult.getConvertDeserializer())));
            }
        }
        return CompatibilityResult.requiresMigration();
    }
}

