/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.ShortValue;

@Internal
public final class ShortValueSerializer
extends TypeSerializerSingleton<ShortValue> {
    private static final long serialVersionUID = 1L;
    public static final ShortValueSerializer INSTANCE = new ShortValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public ShortValue createInstance() {
        return new ShortValue();
    }

    @Override
    public ShortValue copy(ShortValue from) {
        return this.copy(from, new ShortValue());
    }

    @Override
    public ShortValue copy(ShortValue from, ShortValue reuse) {
        reuse.setValue(from.getValue());
        return reuse;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void serialize(ShortValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public ShortValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new ShortValue(), source);
    }

    @Override
    public ShortValue deserialize(ShortValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeShort(source.readShort());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof ShortValueSerializer;
    }

    @Override
    protected boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return super.isCompatibleSerializationFormatIdentifier(identifier) || identifier.equals(ShortSerializer.class.getCanonicalName());
    }
}

