/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.ParameterlessTypeSerializerConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;

@Internal
public abstract class TypeSerializerSingleton<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 8766687317209282373L;

    @Override
    public TypeSerializerSingleton<T> duplicate() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TypeSerializerSingleton) {
            TypeSerializerSingleton other = (TypeSerializerSingleton)obj;
            return other.canEqual(this);
        }
        return false;
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new ParameterlessTypeSerializerConfig(this.getSerializationFormatIdentifier());
    }

    @Override
    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof ParameterlessTypeSerializerConfig && this.isCompatibleSerializationFormatIdentifier(((ParameterlessTypeSerializerConfig)configSnapshot).getSerializationFormatIdentifier())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    protected boolean isCompatibleSerializationFormatIdentifier(String identifier) {
        return identifier.equals(this.getSerializationFormatIdentifier());
    }

    private String getSerializationFormatIdentifier() {
        return this.getClass().getCanonicalName();
    }
}

