/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class ShortPrimitiveArraySerializer
extends TypeSerializerSingleton<short[]> {
    private static final long serialVersionUID = 1L;
    private static final short[] EMPTY = new short[0];
    public static final ShortPrimitiveArraySerializer INSTANCE = new ShortPrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public short[] createInstance() {
        return EMPTY;
    }

    @Override
    public short[] copy(short[] from) {
        short[] copy2 = new short[from.length];
        System.arraycopy(from, 0, copy2, 0, from.length);
        return copy2;
    }

    @Override
    public short[] copy(short[] from, short[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(short[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeShort(record[i]);
        }
    }

    @Override
    public short[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        short[] array2 = new short[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = source.readShort();
        }
        return array2;
    }

    @Override
    public short[] deserialize(short[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len * 2);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof ShortPrimitiveArraySerializer;
    }
}

