/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;

public class DuplicateOnlySerializerFactory<T>
implements TypeSerializerFactory<T> {
    private final TypeSerializer<T> serializer;
    private boolean firstSerializer = true;

    public DuplicateOnlySerializerFactory(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public TypeSerializer<T> getSerializer() {
        if (this.firstSerializer) {
            this.firstSerializer = false;
            return this.serializer;
        }
        return this.serializer.duplicate();
    }

    @Override
    public void writeParametersToConfig(Configuration config) {
        throw new UnsupportedOperationException("Writing is not supported in DuplicateOnlySerializerFactory");
    }

    @Override
    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        throw new UnsupportedOperationException("Reading is not supported in DuplicateOnlySerializerFactory");
    }

    @Override
    public Class<T> getDataType() {
        throw new UnsupportedOperationException("Getting data type is not supported in DuplicateOnlySerializerFactory");
    }
}

