/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.ObjectMap;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.flink.util.InstantiationUtil;

public class JavaSerializer<T>
extends Serializer<T> {
    public void write(Kryo kryo, Output output2, T o) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectOutputStream objectStream = (ObjectOutputStream)graphContext.get((Object)this);
            if (objectStream == null) {
                objectStream = new ObjectOutputStream((OutputStream)output2);
                graphContext.put((Object)this, (Object)objectStream);
            }
            objectStream.writeObject(o);
            objectStream.flush();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java serialization.", (Throwable)ex);
        }
    }

    public T read(Kryo kryo, Input input, Class aClass) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectInputStream objectStream = (ObjectInputStream)graphContext.get((Object)this);
            if (objectStream == null) {
                objectStream = new InstantiationUtil.ClassLoaderObjectInputStream((InputStream)input, kryo.getClassLoader());
                graphContext.put((Object)this, (Object)objectStream);
            }
            return (T)objectStream.readObject();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java deserialization.", (Throwable)ex);
        }
    }
}

