/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class CheckpointingOptions {
    public static final ConfigOption<String> STATE_BACKEND = ConfigOptions.key("state.backend").noDefaultValue().withDescription("The state backend to be used to store and checkpoint state. Supported values are 'jobmanager' for MemoryStateBackend, 'filesystem' for FsStateBackend, and 'rocksdb' for RocksDBStateBackend.");
    public static final ConfigOption<Integer> MAX_RETAINED_CHECKPOINTS = ConfigOptions.key("state.checkpoints.num-retained").defaultValue(1).withDescription("The maximum number of completed checkpoints to retain.");
    public static final ConfigOption<Boolean> ASYNC_SNAPSHOTS = ConfigOptions.key("state.backend.async").defaultValue(true).withDescription("Option whether the state backend should use an asynchronous snapshot method where possible and configurable. Some state backends may not support asynchronous snapshots, or only support asynchronous snapshots, and ignore this option.");
    public static final ConfigOption<Boolean> INCREMENTAL_CHECKPOINTS = ConfigOptions.key("state.backend.incremental").defaultValue(false).withDescription("Option whether the state backend should create incremental checkpoints, if possible. For an incremental checkpoint, only a diff from the previous checkpoint is stored, rather than the complete checkpoint state. Some state backends may not support incremental checkpoints and ignore this option.");
    public static final ConfigOption<String> WORKING_DIRS = ConfigOptions.key("state.backend.working-dirs").noDefaultValue().withDescription("The working directories for file-based state backend.");
    public static final ConfigOption<Boolean> LOCAL_RECOVERY = ConfigOptions.key("state.backend.local-recovery").defaultValue(false);
    public static final ConfigOption<String> LOCAL_RECOVERY_TASK_MANAGER_STATE_ROOT_DIRS = ConfigOptions.key("taskmanager.state.local.root-dirs").noDefaultValue();
    public static final ConfigOption<Integer> CHECKPOINTS_MAX_CONCURRENT_NUM = ConfigOptions.key("state.backend.checkpoints.concurrent-num").defaultValue(1).withDescription("The max concurrent number of checkpoints could run within state backend. If set less than 0, means no limit.");
    public static final ConfigOption<String> SAVEPOINT_DIRECTORY = ConfigOptions.key("state.savepoints.dir").noDefaultValue().withDeprecatedKeys("savepoints.state.backend.fs.dir").withDescription("The default directory for savepoints. Used by the state backends that write savepoints to file systems (MemoryStateBackend, FsStateBackend, RocksDBStateBackend).");
    public static final ConfigOption<String> CHECKPOINTS_DIRECTORY = ConfigOptions.key("state.checkpoints.dir").noDefaultValue().withDeprecatedKeys("state.backend.fs.checkpointdir").withDescription("The default directory used for storing the data files and meta data of checkpoints in a Flink supported filesystem. The storage path must be accessible from all participating processes/nodes(i.e. all TaskManagers and JobManagers).");
    public static final ConfigOption<Boolean> CHCKPOINTS_CREATE_SUBDIRS = ConfigOptions.key("state.checkpoints.create-subdirs").defaultValue(true).withDescription("Whether to create sub-directories with specific jobId to store the data files and meta data of checkpoints. The default value is true to enable user could run several jobs with the same checkpoint directory simultaneously, if this value is set to false, pay attention to not run several jobs with the same directory simultaneously.");
    public static final ConfigOption<Integer> FS_SMALL_FILE_THRESHOLD = ConfigOptions.key("state.backend.fs.memory-threshold").defaultValue(1024).withDescription("The minimum size of state data files. All state chunks smaller than that are stored inline in the root checkpoint metadata file.");
    public static final ConfigOption<Integer> FS_BUFFER_SIZE = ConfigOptions.key("state.backend.fs.buffer-size").defaultValue(0x100000).withDescription(String.format("The default write buffer size for file checkpoint output stream created by FsCheckpointStreamFactory. And the final actual write buffer size would consider the maximum of values of this option and option '%s'.", FS_SMALL_FILE_THRESHOLD.key()));
    public static final ConfigOption<String> ROCKSDB_LOCAL_DIRECTORIES = ConfigOptions.key("state.backend.rocksdb.localdir").noDefaultValue().withDeprecatedKeys("state.backend.rocksdb.checkpointdir").withDescription("The local directory (on the TaskManager) where RocksDB puts its files.");
}

