/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.HeartbeatManagerOptions;

@PublicEvolving
public class JobManagerOptions {
    public static final ConfigOption<String> ADDRESS = ConfigOptions.key("jobmanager.rpc.address").noDefaultValue().withDescription("The config parameter defining the network address to connect to for communication with the job manager. This value is only interpreted in setups where a single JobManager with static name or address exists (simple standalone setups, or container setups with dynamic service name resolution). It is not used in many high-availability setups, when a leader-election service (like ZooKeeper) is used to elect and discover the JobManager leader from potentially multiple standby JobManagers.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key("jobmanager.rpc.port").defaultValue(6123).withDescription("The config parameter defining the network port to connect to for communication with the job manager. Like " + ADDRESS.key() + ", this value is only interpreted in setups where a single JobManager with static name/address and port exists (simple standalone setups, or container setups with dynamic service name resolution). This config option is not used in many high-availability setups, when a leader-election service (like ZooKeeper) is used to elect and discover the JobManager leader from potentially multiple standby JobManagers.");
    public static final ConfigOption<Integer> JOB_MANAGER_HEAP_MEMORY = ConfigOptions.key("jobmanager.heap.mb").defaultValue(1024).withDescription("JVM heap size (in megabytes) for the JobManager.");
    public static final ConfigOption<Integer> MAX_ATTEMPTS_HISTORY_SIZE = ConfigOptions.key("jobmanager.execution.attempts-history-size").defaultValue(16).withDeprecatedKeys("job-manager.max-attempts-history-size").withDescription("The maximum number of prior execution attempts kept in history.");
    public static final ConfigOption<Integer> MAX_EXECUTION_GRAPH_HISTORY_SIZE = ConfigOptions.key("jobmanager.execution.execution-graph-history-size").defaultValue(1).withDescription("The maximum number of prior execution graphs kept in history.");
    public static final ConfigOption<String> EXECUTION_FAILOVER_STRATEGY = ConfigOptions.key("jobmanager.execution.failover-strategy").defaultValue("full").withDescription("The strategy to handle task failures. 'full' failover strategy will restart all tasks in the job. 'region' failover strategy will restart the tasks in the same region with the failed task. Regions are PIPELINED connected task groups in a job.");
    public static final ConfigOption<Integer> EXECUTION_FAILOVER_STRATEGY_REGION_MAX_ATTEMPTS = ConfigOptions.key("jobmanager.execution.failover-strategy.region.attempts").defaultValue(100).withDescription("The maximum number that a region can attempt to restart before triggering job failures. This only works with 'region' failover strategy.");
    public static final ConfigOption<String> GRAPH_MANAGER_PLUGIN = ConfigOptions.key("jobmanager.execution.graph-manager-plugin").noDefaultValue().withDescription("The class name of the graph manager plugin.");
    public static final ConfigOption<Long> RESOURCE_MANAGER_RECONNECT_INTERVAL = ConfigOptions.key("jobmanager.resourcemanager.reconnect-interval").defaultValue(2000L).withDescription("This option specifies the interval in order to trigger a resource manager reconnection if the connection to the resource manager has been lost. This option is only intended for internal use.");
    public static final ConfigOption<String> ARCHIVE_DIR = ConfigOptions.key("jobmanager.archive.fs.dir").noDefaultValue();
    public static final ConfigOption<Long> JOB_STORE_CACHE_SIZE = ConfigOptions.key("jobstore.cache-size").defaultValue(0x3200000L).withDescription("The job store cache size in bytes which is used to keep completed jobs in memory.");
    public static final ConfigOption<Long> JOB_STORE_EXPIRATION_TIME = ConfigOptions.key("jobstore.expiration-time").defaultValue(3600L).withDescription("The time in seconds after which a completed job expires and is purged from the job store.");
    public static final ConfigOption<Long> UPDATE_PARTITION_INFO_SEND_INTERVAL = ConfigOptions.key("jobmanager.update-partition-info.send-interval").defaultValue(10L).withDescription("The interval of send update-partition-info message.");
    public static final ConfigOption<Long> SLOT_REQUEST_TIMEOUT = ConfigOptions.key("slot.request.timeout").defaultValue(300000L).withDescription("The timeout in milliseconds for requesting a slot from Slot Pool.");
    public static final ConfigOption<Long> SLOT_IDLE_TIMEOUT = ConfigOptions.key("slot.idle.timeout").defaultValue(HeartbeatManagerOptions.HEARTBEAT_TIMEOUT.defaultValue()).withDescription("The timeout in milliseconds for a idle slot in Slot Pool.");
    public static final ConfigOption<Boolean> SLOT_ENABLE_SHARED_SLOT = ConfigOptions.key("slot.enable-shared-slot").defaultValue(true).withDescription("Whether to enable slot sharing group when allocating slots in Slot Pool.");
    public static final ConfigOption<Long> JOB_RECONCILE_TIMEOUT = ConfigOptions.key("jobmanager.failover.reconcile-timeout").defaultValue(60L).withDescription("The timeout for job master to reconcile with task executors for recovering the execution status.");
    public static final ConfigOption<String> OPERATION_LOG_STORE = ConfigOptions.key("jobmanager.failover.operation-log-store").defaultValue("none").withDescription("The operation log store type for job master failover.");
    public static final ConfigOption<Integer> OPLOG_FLUSH_INTERVAL = ConfigOptions.key("jobmanager.failover.operation-log-flush-interval").defaultValue(3000).withDescription("The operation log store flush interval in ms.");

    private JobManagerOptions() {
        throw new IllegalAccessError();
    }
}

