/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@ConfigGroups(groups={@ConfigGroup(name="Kerberos", keyPrefix="security.kerberos"), @ConfigGroup(name="ZooKeeper", keyPrefix="zookeeper")})
@PublicEvolving
public class SecurityOptions {
    public static final ConfigOption<String> KERBEROS_LOGIN_PRINCIPAL = ConfigOptions.key("security.kerberos.login.principal").noDefaultValue().withDeprecatedKeys("security.principal").withDescription("Kerberos principal name associated with the keytab.");
    public static final ConfigOption<String> KERBEROS_LOGIN_KEYTAB = ConfigOptions.key("security.kerberos.login.keytab").noDefaultValue().withDeprecatedKeys("security.keytab").withDescription("Absolute path to a Kerberos keytab file that contains the user credentials.");
    public static final ConfigOption<Boolean> KERBEROS_LOGIN_USETICKETCACHE = ConfigOptions.key("security.kerberos.login.use-ticket-cache").defaultValue(true).withDescription("Indicates whether to read from your Kerberos ticket cache.");
    public static final ConfigOption<String> KERBEROS_LOGIN_CONTEXTS = ConfigOptions.key("security.kerberos.login.contexts").noDefaultValue().withDescription("A comma-separated list of login contexts to provide the Kerberos credentials to (for example, `Client,KafkaClient` to use the credentials for ZooKeeper authentication and for Kafka authentication)");
    public static final ConfigOption<Boolean> ZOOKEEPER_SASL_DISABLE = ConfigOptions.key("zookeeper.sasl.disable").defaultValue(false);
    public static final ConfigOption<String> ZOOKEEPER_SASL_SERVICE_NAME = ConfigOptions.key("zookeeper.sasl.service-name").defaultValue("zookeeper");
    public static final ConfigOption<String> ZOOKEEPER_SASL_LOGIN_CONTEXT_NAME = ConfigOptions.key("zookeeper.sasl.login-context-name").defaultValue("Client");
    public static final ConfigOption<Boolean> SSL_ENABLED = ConfigOptions.key("security.ssl.enabled").defaultValue(false).withDescription("Turns on SSL for internal network communication. This can be optionally overridden by flags defined in different transport modules.");
    public static final ConfigOption<String> SSL_KEYSTORE = ConfigOptions.key("security.ssl.keystore").noDefaultValue().withDescription("The Java keystore file to be used by the flink endpoint for its SSL Key and Certificate.");
    public static final ConfigOption<String> SSL_KEYSTORE_PASSWORD = ConfigOptions.key("security.ssl.keystore-password").noDefaultValue().withDescription("The secret to decrypt the keystore file.");
    public static final ConfigOption<String> SSL_KEY_PASSWORD = ConfigOptions.key("security.ssl.key-password").noDefaultValue().withDescription("The secret to decrypt the server key in the keystore.");
    public static final ConfigOption<String> SSL_TRUSTSTORE = ConfigOptions.key("security.ssl.truststore").noDefaultValue().withDescription("The truststore file containing the public CA certificates to be used by flink endpoints to verify the peer\u2019s certificate.");
    public static final ConfigOption<String> SSL_TRUSTSTORE_PASSWORD = ConfigOptions.key("security.ssl.truststore-password").noDefaultValue().withDescription("The secret to decrypt the truststore.");
    public static final ConfigOption<String> SSL_PROTOCOL = ConfigOptions.key("security.ssl.protocol").defaultValue("TLSv1.2").withDescription("The SSL protocol version to be supported for the ssl transport. Note that it doesn\u2019t support comma separated list.");
    public static final ConfigOption<String> SSL_ALGORITHMS = ConfigOptions.key("security.ssl.algorithms").defaultValue("TLS_RSA_WITH_AES_128_CBC_SHA").withDescription("The comma separated list of standard SSL algorithms to be supported. Read more <a href=\"http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites\">here</a>.");
    public static final ConfigOption<Boolean> SSL_VERIFY_HOSTNAME = ConfigOptions.key("security.ssl.verify-hostname").defaultValue(true).withDescription("Flag to enable peer\u2019s hostname verification during ssl handshake.");
}

