/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.SecurityOptions;

@PublicEvolving
public class TaskManagerOptions {
    public static final ConfigOption<Integer> TASK_MANAGER_HEAP_MEMORY = ConfigOptions.key("taskmanager.heap.mb").defaultValue(1024).withDescription("How many heap memory (in megabytes) a task manager will supply for user, not including managed memory.");
    public static final ConfigOption<Double> TASK_MANAGER_CORE = ConfigOptions.key("taskmanager.cpu.core").defaultValue(1.0).withDescription("How many physical cpu cores a task manager will supply for user");
    public static final ConfigOption<Integer> TASK_MANAGER_DIRECT_MEMORY = ConfigOptions.key("taskmanager.direct.memory.mb").defaultValue(0).withDescription("How many direct memory (in megabytes) a task manager will supply for user.");
    public static final ConfigOption<Integer> TASK_MANAGER_NATIVE_MEMORY = ConfigOptions.key("taskmanager.native.memory.mb").defaultValue(0).withDescription("How many native memory (in megabytes) a task manager will supply for user.");
    public static final ConfigOption<String> TASK_MANAGER_EXTENDED_RESOURCES = ConfigOptions.key("taskmanager.extended.resources").noDefaultValue().withDescription("Extended resources will supply for user. Specified as resource-type:value pairs separated by commas. such as GPU:1,FPGA:1.");
    public static final ConfigOption<Integer> TASK_MANAGER_PROCESS_HEAP_MEMORY = ConfigOptions.key("taskmanager.process.heap.memory.mb").defaultValue(128).withDescription("The heap memory (in megabytes) used for task manager process.");
    public static final ConfigOption<Integer> TASK_MANAGER_PROCESS_NATIVE_MEMORY = ConfigOptions.key("taskmanager.process.native.memory.mb").defaultValue(0).withDescription("The native memory (in megabytes) used for task manager process.");
    public static final ConfigOption<Integer> TASK_MANAGER_PROCESS_NETTY_MEMORY = ConfigOptions.key("taskmanager.process.netty.memory.mb").defaultValue(64).withDescription("The direct memory (in megabytes) used for netty framework in the task manager process.");
    public static final ConfigOption<Double> TASK_MANAGER_MEMORY_DYNAMIC_YOUNG_RATIO = ConfigOptions.key("taskmanager.jvm.memory.dynamic.young.ratio").defaultValue(0.25).withDescription("Ratio of young generation for dynamic memory in task manager.");
    public static final ConfigOption<Double> TASK_MANAGER_MEMORY_PERSISTENT_YOUNG_RATIO = ConfigOptions.key("taskmanager.jvm.memory.persistent.young.ratio").defaultValue(0.1).withDescription("Ratio of young generation for persistent memory in task manager.");
    public static final ConfigOption<Double> TASK_MANAGER_MAX_CORE = ConfigOptions.key("taskmanager.max.cpu.core").defaultValue(32.0).withDescription("Max cpu cores for a task manager.");
    public static final ConfigOption<Integer> TASK_MANAGER_MAX_MEMORY = ConfigOptions.key("taskmanager.max.memory.mb").defaultValue(131072).withDescription("Max memory (in megabytes) for a task manager.");
    public static final ConfigOption<Double> TASK_MANAGER_MIN_CORE = ConfigOptions.key("taskmanager.min.cpu.core").defaultValue(0.25).withDescription("Min cpu cores for a task manager.");
    public static final ConfigOption<Integer> TASK_MANAGER_MIN_MEMORY = ConfigOptions.key("taskmanager.min.memory.mb").defaultValue(1024).withDescription("Min memory (in megabytes) for a task manager.");
    public static final ConfigOption<Double> TASK_MANAGER_MULTI_SLOT_PREFERRED_CORE = ConfigOptions.key("taskmanager.multi-slot.preferred.cpu.core").defaultValue(1.0).withDescription("Preferred cpu cores for a task manager, used to decide how many slots can be placed on a task manager.");
    public static final ConfigOption<Integer> TASK_MANAGER_MULTI_SLOT_PREFERRED_MEMORY = ConfigOptions.key("taskmanager.multi-slot.preferred.memory.mb").defaultValue(4096).withDescription("Preferred memory (in megabytes) for a task manager, used to decide how many slots can be placed on a task manager.");
    public static final ConfigOption<String> TASK_MANAGER_MULTI_SLOTS_PREFERRED_EXTENDED_RESOURCES = ConfigOptions.key("taskmanager.multi-slots.preferred.extended-resources").defaultValue("").withDescription("Preferred extended resources for a task manager, used to decide how many slots can be placed on a task manager. String format is like \"GPU=10,FPGA=12\".");
    public static final ConfigOption<String> TASK_MANAGER_RESOURCE_PROFILE_KEY = ConfigOptions.key("taskmanager.resourceProfile").defaultValue("").withDescription("The resource profile of a slot in a task executor.");
    public static final ConfigOption<String> TASK_MANAGER_TOTAL_RESOURCE_PROFILE_KEY = ConfigOptions.key("taskmanager.total.resourceProfile").defaultValue("").withDescription("The total resource profile of all the slots in a task executor.");
    public static final ConfigOption<Boolean> KILL_ON_OUT_OF_MEMORY = ConfigOptions.key("taskmanager.jvm-exit-on-oom").defaultValue(false).withDescription("Whether to kill the TaskManager when the task thread throws an OutOfMemoryError.");
    public static final ConfigOption<Boolean> EXIT_ON_FATAL_AKKA_ERROR = ConfigOptions.key("taskmanager.exit-on-fatal-akka-error").defaultValue(false).withDescription("Whether the quarantine monitor for task managers shall be started. The quarantine monitor shuts down the actor system if it detects that it has quarantined another actor system or if it has been quarantined by another actor system.");
    public static final ConfigOption<String> HOST = ConfigOptions.key("taskmanager.host").noDefaultValue().withDescription("The hostname of the network interface that the TaskManager binds to. By default, the TaskManager searches for network interfaces that can connect to the JobManager and other TaskManagers. This option can be used to define a hostname if that strategy fails for some reason. Because different TaskManagers need different values for this option, it usually is specified in an additional non-shared TaskManager-specific config file.");
    public static final ConfigOption<String> RPC_PORT = ConfigOptions.key("taskmanager.rpc.port").defaultValue("0").withDescription("The task manager\u2019s IPC port. Accepts a list of ports (\u201c50100,50101\u201d), ranges (\u201c50100-50200\u201d) or a combination of both. It is recommended to set a range of ports to avoid collisions when multiple TaskManagers are running on the same machine.");
    public static final ConfigOption<Integer> DATA_PORT = ConfigOptions.key("taskmanager.data.port").defaultValue(0).withDescription("The task manager\u2019s port used for data exchange operations.");
    public static final ConfigOption<Boolean> DATA_SSL_ENABLED = ConfigOptions.key("taskmanager.data.ssl.enabled").defaultValue(true).withDescription("Enable SSL support for the taskmanager data transport. This is applicable only when the global ssl flag " + SecurityOptions.SSL_ENABLED.key() + " is set to true");
    public static final ConfigOption<String> INITIAL_REGISTRATION_BACKOFF = ConfigOptions.key("taskmanager.registration.initial-backoff").defaultValue("500 ms").withDeprecatedKeys("taskmanager.initial-registration-pause").withDescription("The initial registration backoff between two consecutive registration attempts. The backoff is doubled for each new registration attempt until it reaches the maximum registration backoff.");
    public static final ConfigOption<String> REGISTRATION_MAX_BACKOFF = ConfigOptions.key("taskmanager.registration.max-backoff").defaultValue("30 s").withDeprecatedKeys("taskmanager.max-registration-pause").withDescription("The maximum registration backoff between two consecutive registration attempts. The max registration backoff requires a time unit specifier (ms/s/min/h/d).");
    public static final ConfigOption<String> REFUSED_REGISTRATION_BACKOFF = ConfigOptions.key("taskmanager.registration.refused-backoff").defaultValue("10 s").withDeprecatedKeys("taskmanager.refused-registration-pause").withDescription("The backoff after a registration has been refused by the job manager before retrying to connect.");
    public static final ConfigOption<String> REGISTRATION_TIMEOUT = ConfigOptions.key("taskmanager.registration.timeout").defaultValue("5 min").withDeprecatedKeys("taskmanager.maxRegistrationDuration").withDescription("Defines the timeout for the TaskManager registration. If the duration is exceeded without a successful registration, then the TaskManager terminates.");
    public static final ConfigOption<String> RECONNECTION_TIMEOUT = ConfigOptions.key("taskmanager.reconnection.timeout").defaultValue("1 min").withDescription("Defines the maximum time it can take for the TaskManager reconnection. If the duration is exceeded without a successful reconnection, then disassociate from JM.");
    public static final ConfigOption<Integer> NUM_TASK_SLOTS = ConfigOptions.key("taskmanager.numberOfTaskSlots").defaultValue(1).withDescription("The number of parallel operator or user function instances that a single TaskManager can run. If this value is larger than 1, a single TaskManager takes multiple instances of a function or operator. That way, the TaskManager can utilize multiple CPU cores, but at the same time, the available memory is divided between the different operator or function instances. This value is typically proportional to the number of physical CPU cores that the TaskManager's machine has (e.g., equal to the number of cores, or half the number of cores).");
    public static final ConfigOption<Boolean> DEBUG_MEMORY_LOG = ConfigOptions.key("taskmanager.debug.memory.log").defaultValue(false).withDeprecatedKeys("taskmanager.debug.memory.startLogThread").withDescription("Flag indicating whether to start a thread, which repeatedly logs the memory usage of the JVM.");
    public static final ConfigOption<Long> DEBUG_MEMORY_USAGE_LOG_INTERVAL_MS = ConfigOptions.key("taskmanager.debug.memory.log-interval").defaultValue(5000L).withDeprecatedKeys("taskmanager.debug.memory.logIntervalMs").withDescription("The interval (in ms) for the log thread to log the current memory usage.");
    public static final ConfigOption<Integer> TASK_MANAGER_CAPACITY_MEMORY_MB = ConfigOptions.key("taskmanager.capacity.memory.mb").defaultValue(-1).withDescription("The overall memory in MB that allocated to the task manager.");
    public static final ConfigOption<Double> TASK_MANAGER_CAPACITY_CPU_CORE = ConfigOptions.key("taskmanager.capacity.cpu.core").defaultValue(-1.0).withDescription("The overall cpu cores allocated to the task manager.");
    public static final ConfigOption<String> TASK_BLOCKING_SHUFFLE_TYPE = ConfigOptions.key("task.blocking.shuffle.type").defaultValue("TM").withDescription("The type of shuffle service used for blocking edge. Currently it can be configured to TM or YARN.");
    public static final ConfigOption<String> TASK_MANAGER_OUTPUT_LOCAL_DISK_TYPE = ConfigOptions.key("taskmanager.output.local-disk.type").defaultValue("").withDescription("The disk type preferred to write the shuffle data. If not specified, all the root directories are feasible. If specified, only directories with the configured type are feasible.");
    public static final ConfigOption<String> TASK_MANAGER_OUTPUT_LOCAL_OUTPUT_DIRS = ConfigOptions.key("taskmanager.output.local-output-dirs").defaultValue("").withDescription("The available directories for the external shuffle service. It will be configured automatically and should not be configured manually.");
    public static final ConfigOption<Integer> TASK_MANAGER_OUTPUT_MEMORY_MB = ConfigOptions.key("taskmanager.output.memory.mb").defaultValue(200).withDescription("The write buffer size for each output in a task.");
    public static final ConfigOption<Integer> TASK_MANAGER_OUTPUT_HASH_MAX_SUBPARTITIONS = ConfigOptions.key("taskmanager.output.hash.max-subpartitions").defaultValue(200).withDescription("The maximum number of subpartitions supported by the hash writer.");
    public static final ConfigOption<Integer> TASK_MANAGER_OUTPUT_MERGE_FACTOR = ConfigOptions.key("taskmanager.output.merge.factor").defaultValue(64).withDescription("The maximum number of files to merge at once when using the merge writer.");
    public static final ConfigOption<Boolean> TASK_MANAGER_OUTPUT_MERGE_TO_ONE_FILE = ConfigOptions.key("taskmanager.output.merge.merge-to-one-file").defaultValue(false).withDescription("Whether to merge to one file finally when using the merge writer. If not, the merge stops once the number of files are less than taskmanager.output.merge.factor.");
    public static final ConfigOption<Boolean> TASK_MANAGER_OUTPUT_ENABLE_ASYNC_MERGE = ConfigOptions.key("taskmanager.output.merge.enable-async-merge").defaultValue(false).withDescription("Whether to start merge while writing has not been finished.");
    public static final ConfigOption<Integer> TASK_EXTERNAL_SHUFFLE_MAX_CONCURRENT_REQUESTS = ConfigOptions.key("task.external.shuffle.max-concurrent-requests").defaultValue(10).withDescription("The maximum number of concurrent requests in the reduce-side tasks.");
    public static final ConfigOption<Integer> NETWORK_BUFFERS_PER_EXTERNAL_BLOCKING_CHANNEL = ConfigOptions.key("taskmanager.network.memory.buffers-per-external-blocking-channel").defaultValue(128).withDescription("The number of buffers available for each external blocking channel.");
    public static final ConfigOption<Integer> NETWORK_EXTRA_BUFFERS_PER_EXTERNAL_BLOCKING_GATE = ConfigOptions.key("taskmanager.network.memory.floating-buffers-per-external-blocking-gate").defaultValue(0).withDescription("taskmanager.network.memory.floating-buffers-per-external-blocking-gate");
    public static final ConfigOption<Boolean> TASK_EXTERNAL_SHUFFLE_ENABLE_COMPRESSION = ConfigOptions.key("task.external.shuffle.compression.enable").defaultValue(false).withDescription("Whether to enable compress shuffle data when using external shuffle.");
    public static final ConfigOption<String> TASK_EXTERNAL_SHUFFLE_COMPRESSION_CODEC = ConfigOptions.key("task.external.shuffle.compression.codec").defaultValue("lz4").withDescription("The codec to use when compress or decompress external shuffle data. Currently supported codecs are lz4, bzip2, gzip. User can also implement interface BlockCompressionFactory and set its class to specify other codecs.");
    public static final ConfigOption<Integer> TASK_EXTERNAL_SHUFFLE_COMPRESSION_BUFFER_SIZE = ConfigOptions.key("task.external.shuffle.compression.buffer-size").defaultValue(32768).withDescription("The max buffer size to compress external shuffle data.");
    public static final ConfigOption<Integer> TASK_EXTERNAL_SHUFFLE_CONSUMED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key("task.external.shuffle.consumed-partition-ttl-in-seconds").defaultValue(3600).withDescription("The time interval to delete the fully consumed shuffle data directories since they become inactive.");
    public static final ConfigOption<Integer> TASK_EXTERNAL_SHUFFLE_PARTIAL_CONSUMED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key("task.external.shuffle.partial-consumed-partition-ttl-in-seconds").defaultValue(43200).withDescription("The time interval to delete the partially consumed shuffle data directories since they become inactive.");
    public static final ConfigOption<Integer> TASK_EXTERNAL_SHUFFLE_UNCONSUMED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key("task.external.shuffle.unconsumed-partition-ttl-in-seconds").defaultValue(43200).withDescription("TThe time interval to delete the unconsumed shuffle data directories since they are ready to consume.");
    public static final ConfigOption<Integer> TASK_EXTERNAL_SHUFFLE_UNFINISHED_PARTITION_TTL_IN_SECONDS = ConfigOptions.key("task.external.shuffle.unfinished-partition-ttl-in-seconds").defaultValue(3600).withDescription("The time interval to delete the writing shuffle data directories since the last writing.");
    public static final ConfigOption<Integer> MEMORY_SEGMENT_SIZE = ConfigOptions.key("taskmanager.memory.segment-size").defaultValue(32768).withDescription("Size of memory buffers used by the network stack and the memory manager (in bytes).");
    public static final ConfigOption<Long> MANAGED_MEMORY_SIZE = ConfigOptions.key("taskmanager.managed.memory.size").defaultValue(-1L).withDeprecatedKeys("taskmanager.memory.size").withDescription("Amount of memory to be allocated by the task manager's memory manager (in megabytes). If not set, a relative fraction will be allocated.");
    public static final ConfigOption<Float> MANAGED_MEMORY_FRACTION = ConfigOptions.key("taskmanager.memory.fraction").defaultValue(Float.valueOf(0.7f)).withDescription("The relative amount of memory (after subtracting the amount of memory used by network buffers) that the task manager reserves for sorting, hash tables, and caching of intermediate results. For example, a value of `0.8` means that a task manager reserves 80% of its memory for internal data buffers, leaving 20% of free memory for the task manager's heap for objects created by user-defined functions. This parameter is only evaluated, if " + MANAGED_MEMORY_SIZE.key() + " is not set.");
    public static final ConfigOption<Long> FLOATING_MANAGED_MEMORY_SIZE = ConfigOptions.key("taskmanager.floating.memory.size").defaultValue(0L);
    public static final ConfigOption<Boolean> MEMORY_OFF_HEAP = ConfigOptions.key("taskmanager.memory.off-heap").defaultValue(false).withDescription("Memory allocation method (JVM heap or off-heap), used for managed memory of the TaskManager as well as the network buffers.");
    public static final ConfigOption<Boolean> MANAGED_MEMORY_PRE_ALLOCATE = ConfigOptions.key("taskmanager.memory.preallocate").defaultValue(false).withDescription("Whether TaskManager managed memory should be pre-allocated when the TaskManager is starting.");
    @Deprecated
    public static final ConfigOption<Integer> NETWORK_NUM_BUFFERS = ConfigOptions.key("taskmanager.network.numberOfBuffers").defaultValue(2048);
    public static final ConfigOption<Float> NETWORK_BUFFERS_MEMORY_FRACTION = ConfigOptions.key("taskmanager.network.memory.fraction").defaultValue(Float.valueOf(0.1f)).withDescription("Fraction of JVM memory to use for network buffers. This determines how many streaming data exchange channels a TaskManager can have at the same time and how well buffered the channels are. If a job is rejected or you get a warning that the system has not enough buffers available, increase this value or the min/max values below. Also note, that \"taskmanager.network.memory.min\"` and \"taskmanager.network.memory.max\" may override this fraction.");
    public static final ConfigOption<Long> NETWORK_BUFFERS_MEMORY_MIN = ConfigOptions.key("taskmanager.network.memory.min").defaultValue(0x10000000L).withDescription("Minimum memory size for network buffers (in bytes).");
    public static final ConfigOption<Long> NETWORK_BUFFERS_MEMORY_MAX = ConfigOptions.key("taskmanager.network.memory.max").defaultValue(0x40000000L).withDescription("Maximum memory size for network buffers (in bytes).");
    public static final ConfigOption<Integer> NETWORK_BUFFERS_PER_CHANNEL = ConfigOptions.key("taskmanager.network.memory.buffers-per-channel").defaultValue(2).withDescription("Maximum number of network buffers to use for each outgoing/incoming channel (subpartition/input channel).In credit-based flow control mode, this indicates how many credits are exclusive in each input channel. It should be configured at least 2 for good performance. 1 buffer is for receiving in-flight data in the subpartition and 1 buffer is for parallel serialization.");
    public static final ConfigOption<Integer> NETWORK_BUFFERS_PER_SUBPARTITION = ConfigOptions.key("taskmanager.network.memory.buffers-per-subpartition").defaultValue(2);
    public static final ConfigOption<Integer> NETWORK_EXTRA_BUFFERS_PER_GATE = ConfigOptions.key("taskmanager.network.memory.floating-buffers-per-gate").defaultValue(8).withDescription("Number of extra network buffers to use for each outgoing/incoming gate (result partition/input gate). In credit-based flow control mode, this indicates how many floating credits are shared among all the input channels. The floating buffers are distributed based on backlog (real-time output buffers in the subpartition) feedback, and can help relieve back-pressure caused by unbalanced data distribution among the subpartitions. This value should be increased in case of higher round trip times between nodes and/or larger number of machines in the cluster.");
    public static final ConfigOption<Integer> NETWORK_REQUEST_BACKOFF_INITIAL = ConfigOptions.key("taskmanager.network.request-backoff.initial").defaultValue(100).withDeprecatedKeys("taskmanager.net.request-backoff.initial").withDescription("Minimum backoff for partition requests of input channels.");
    public static final ConfigOption<Integer> NETWORK_REQUEST_BACKOFF_MAX = ConfigOptions.key("taskmanager.network.request-backoff.max").defaultValue(10000).withDeprecatedKeys("taskmanager.net.request-backoff.max").withDescription("Maximum backoff for partition requests of input channels.");
    public static final ConfigOption<Boolean> NETWORK_DETAILED_METRICS = ConfigOptions.key("taskmanager.network.detailed-metrics").defaultValue(false).withDescription("Boolean flag to enable/disable more detailed metrics about inbound/outbound network queue lengths.");
    @Deprecated
    public static final ConfigOption<Boolean> NETWORK_CREDIT_MODEL = ConfigOptions.key("taskmanager.network.credit-model").defaultValue(true).withDeprecatedKeys("taskmanager.network.credit-based-flow-control.enabled").withDescription("Boolean flag to enable/disable network credit-based flow control.");
    public static final ConfigOption<Boolean> CHECK_PARTITION_PRODUCER_STATE = ConfigOptions.key("taskmanager.network.check-partition-producer-state").defaultValue(false).withDescription("Boolean flag indicates whether to check partition producer state if the task requests a partition failed and wants to re-trigger the partition request. The task will re-trigger the partition request if the producer is healthy or fail otherwise.");
    public static final ConfigOption<Long> TASK_CANCELLATION_INTERVAL = ConfigOptions.key("task.cancellation.interval").defaultValue(30000L).withDeprecatedKeys("task.cancellation-interval").withDescription("Time interval between two successive task cancellation attempts in milliseconds.");
    public static final ConfigOption<Long> TASK_CANCELLATION_TIMEOUT = ConfigOptions.key("task.cancellation.timeout").defaultValue(180000L).withDescription("Timeout in milliseconds after which a task cancellation times out and leads to a fatal TaskManager error. A value of 0 deactivates the watch dog.");
    public static final ConfigOption<Long> TASK_CANCELLATION_TIMEOUT_TIMERS = ConfigOptions.key("task.cancellation.timers.timeout").defaultValue(7500L).withDeprecatedKeys("timerservice.exceptional.shutdown.timeout");
    public static final ConfigOption<Long> TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT = ConfigOptions.key("task.checkpoint.alignment.max-size").defaultValue(-1L).withDescription("The maximum number of bytes that a checkpoint alignment may buffer. If the checkpoint alignment buffers more than the configured amount of data, the checkpoint is aborted (skipped). A value of -1 indicates that there is no limit.");
    public static final ConfigOption<Integer> IO_MANAGER_BUFFERED_READ_SIZE = ConfigOptions.key("io.manager.buffered.read.size").defaultValue(-1).withDescription("The buffer size of io manager buffered read, -1 mean not use buffered read, this will reduce random IO, but will result in more than one copy.");
    public static final ConfigOption<Integer> IO_MANAGER_BUFFERED_WRITE_SIZE = ConfigOptions.key("io.manager.buffered.write.size").defaultValue(-1).withDescription("The buffer size of io manager buffered write, -1 mean not use buffered write, this will reduce random IO, but will result in more than one copy.");
    public static final ConfigOption<Integer> IO_MANAGER_ASYNC_NUM_READ_WRITE_THREAD = ConfigOptions.key("io.manager.async.num-read-write-thread").defaultValue(1).withDescription("The number of async read write thread.");

    private TaskManagerOptions() {
    }
}

