/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.internal.InternalFoldingState;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

@Deprecated
public class RocksDBFoldingState<K, N, T, ACC>
extends AbstractRocksDBState<K, N, ACC, FoldingState<T, ACC>>
implements InternalFoldingState<K, N, T, ACC> {
    private final FoldFunction<T, ACC> foldFunction;

    public RocksDBFoldingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<ACC> valueSerializer, ACC defaultValue, FoldFunction<T, ACC> foldFunction, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
        this.foldFunction = foldFunction;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<ACC> getValueSerializer() {
        return this.valueSerializer;
    }

    public ACC get() {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return null;
            }
            return (ACC)this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStreamWithPos(valueBytes)));
        }
        catch (IOException | RocksDBException e2) {
            throw new RuntimeException("Error while retrieving data from RocksDB", e2);
        }
    }

    public void add(T value) throws IOException {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(this.keySerializationStream);
            if (valueBytes == null) {
                this.keySerializationStream.reset();
                this.valueSerializer.serialize(this.foldFunction.fold(this.getDefaultValue(), value), out);
                this.backend.db.put(this.columnFamily, this.writeOptions, key, this.keySerializationStream.toByteArray());
            } else {
                Object oldValue = this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStreamWithPos(valueBytes)));
                ACC newValue = this.foldFunction.fold(oldValue, value);
                this.keySerializationStream.reset();
                this.valueSerializer.serialize(newValue, out);
                this.backend.db.put(this.columnFamily, this.writeOptions, key, this.keySerializationStream.toByteArray());
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Error while adding data to RocksDB", e2);
        }
    }
}

