/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import org.apache.flink.contrib.streaming.state.RocksDBStorageInstance;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class RocksDBPair
implements Pair<byte[], byte[]> {
    private final RocksDBStorageInstance storageInstance;
    private final byte[] key;
    private byte[] value;
    private boolean deleted;

    RocksDBPair(RocksDBStorageInstance storageInstance, byte[] key, byte[] value) {
        this.storageInstance = Preconditions.checkNotNull(storageInstance);
        this.key = Preconditions.checkNotNull(key);
        this.value = Preconditions.checkNotNull(value);
        this.deleted = false;
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    void remove() {
        Preconditions.checkState(!this.deleted);
        this.deleted = true;
        this.value = null;
        this.storageInstance.delete(this.key);
    }

    boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public byte[] setValue(byte[] value) {
        if (this.deleted) {
            throw new IllegalStateException("Set value on deleted key.");
        }
        byte[] oldValue = this.value;
        this.storageInstance.put(this.key, value);
        this.value = value;
        return oldValue;
    }
}

