/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Map;
import org.apache.flink.contrib.streaming.state.RocksDBBatchPutWrapper;
import org.apache.flink.contrib.streaming.state.RocksDBWriteBatchWrapper;
import org.apache.flink.runtime.state.BatchPutWrapper;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.runtime.state.StorageInstance;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteOptions;

public class RocksDBStorageInstance
implements StorageInstance,
AutoCloseable {
    static final String SST_FILE_SUFFIX = ".sst";
    private final RocksDB db;
    private final ColumnFamilyHandle columnFamilyHandle;
    private final WriteOptions writeOptions;

    public RocksDBStorageInstance(RocksDB db, ColumnFamilyHandle columnFamilyHandle, WriteOptions writeOptions) {
        this.db = Preconditions.checkNotNull(db);
        this.columnFamilyHandle = Preconditions.checkNotNull(columnFamilyHandle);
        this.writeOptions = Preconditions.checkNotNull(writeOptions);
    }

    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.columnFamilyHandle;
    }

    RocksDB getDb() {
        return this.db;
    }

    byte[] get(byte[] keyBytes) {
        try {
            return this.db.get(this.columnFamilyHandle, keyBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void put(byte[] keyBytes, byte[] valueBytes) {
        try {
            this.db.put(this.columnFamilyHandle, this.writeOptions, keyBytes, valueBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void multiPut(Map<byte[], byte[]> keyValueBytesMap) {
        try (RocksDBWriteBatchWrapper writeBatchWrapper = new RocksDBWriteBatchWrapper(this.db, this.writeOptions);){
            for (Map.Entry<byte[], byte[]> entry : keyValueBytesMap.entrySet()) {
                writeBatchWrapper.put(this.columnFamilyHandle, entry.getKey(), entry.getValue());
            }
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void delete(byte[] keyBytes) {
        try {
            this.db.delete(this.columnFamilyHandle, this.writeOptions, keyBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void merge(byte[] keyBytes, byte[] partialValueBytes) {
        try {
            this.db.merge(this.columnFamilyHandle, this.writeOptions, keyBytes, partialValueBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    RocksIterator iterator() {
        return this.db.newIterator(this.columnFamilyHandle);
    }

    void snapshot(String localCheckpointPath) throws RocksDBException {
        Checkpoint checkpoint = Checkpoint.create((RocksDB)this.db);
        checkpoint.createCheckpoint(localCheckpointPath);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.columnFamilyHandle);
    }

    public BatchPutWrapper getBatchPutWrapper() {
        return new RocksDBBatchPutWrapper(new RocksDBWriteBatchWrapper(this.db, this.writeOptions), this.columnFamilyHandle);
    }
}

