/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import javax.annotation.Nullable;
import org.apache.flink.contrib.streaming.state.AbstractRocksDbStorageIterator;
import org.apache.flink.contrib.streaming.state.RocksDBPair;
import org.apache.flink.contrib.streaming.state.RocksDBStorageInstance;
import org.apache.flink.runtime.state.StorageIterator;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class RocksDBStoragePrefixIterator
implements StorageIterator<byte[], byte[]> {
    private final RocksDBStorageInstance dbStorageInstance;
    @Nullable
    private final byte[] prefixKey;
    private final AbstractRocksDbStorageIterator<RocksDBPair> prefixIterator;

    public RocksDBStoragePrefixIterator(RocksDBStorageInstance dbStorageInstance, final byte[] prefixKey) {
        this.dbStorageInstance = dbStorageInstance;
        this.prefixKey = prefixKey;
        this.prefixIterator = new AbstractRocksDbStorageIterator<RocksDBPair>(dbStorageInstance){

            @Override
            byte[] getStartDBKey() {
                return prefixKey;
            }

            @Override
            boolean isEndDBKey(byte[] dbKey) {
                return prefixKey != null && !RocksDBStoragePrefixIterator.this.isPrefixWith(dbKey);
            }

            @Override
            public RocksDBPair next() {
                return this.getNextPair();
            }
        };
    }

    public void close() throws Exception {
    }

    public void remove() {
        this.prefixIterator.remove();
    }

    public boolean hasNext() {
        return this.prefixIterator.hasNext();
    }

    public Pair<byte[], byte[]> next() {
        return (Pair)this.prefixIterator.next();
    }

    private boolean isPrefixWith(byte[] bytes) {
        Preconditions.checkArgument(bytes != null);
        if (bytes.length < this.prefixKey.length) {
            return false;
        }
        for (int i = 0; i < this.prefixKey.length; ++i) {
            if (bytes[i] == this.prefixKey[i]) continue;
            return false;
        }
        return true;
    }
}

