/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

public class RocksDBValueState<K, N, V>
extends AbstractRocksDBState<K, N, V, ValueState<V>>
implements InternalValueState<K, N, V> {
    public RocksDBValueState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public V value() {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return this.getDefaultValue();
            }
            return (V)this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStream(valueBytes)));
        }
        catch (IOException | RocksDBException e2) {
            throw new RuntimeException("Error while retrieving data from RocksDB.", e2);
        }
    }

    public void update(V value) throws IOException {
        if (value == null) {
            this.clear();
            return;
        }
        DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(this.keySerializationStream);
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            this.keySerializationStream.reset();
            this.valueSerializer.serialize(value, out);
            this.backend.db.put(this.columnFamily, this.writeOptions, key, this.keySerializationStream.toByteArray());
        }
        catch (Exception e2) {
            throw new RuntimeException("Error while adding data to RocksDB", e2);
        }
    }
}

