/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.EOFException;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractMultiFSDataInputStream
extends FSDataInputStream {
    protected FSDataInputStream delegate;
    protected long totalPos = 0L;
    protected long totalAvailable;

    @Override
    public void seek(long desired) throws IOException {
        if (desired == this.totalPos) {
            return;
        }
        Preconditions.checkArgument(desired >= 0L);
        if (desired > this.totalAvailable) {
            throw new EOFException();
        }
        IOUtils.closeQuietly(this.delegate);
        this.delegate = this.getSeekedStreamForOffset(desired);
        this.totalPos = desired;
    }

    @Override
    public long getPos() throws IOException {
        return this.totalPos;
    }

    @Override
    public int read() throws IOException {
        if (null == this.delegate) {
            return -1;
        }
        int val = this.delegate.read();
        if (-1 == val) {
            IOUtils.closeQuietly(this.delegate);
            this.delegate = this.totalPos < this.totalAvailable ? this.getSeekedStreamForOffset(this.totalPos) : null;
            return this.read();
        }
        ++this.totalPos;
        return val;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.delegate);
    }

    @Override
    public long skip(long n) throws IOException {
        this.seek(this.totalPos + n);
        return n;
    }

    protected abstract FSDataInputStream getSeekedStreamForOffset(long var1) throws IOException;
}

