/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import org.apache.flink.annotation.Internal;
import sun.misc.Unsafe;

@Internal
public class MemoryUtils {
    public static final Unsafe UNSAFE = MemoryUtils.getUnsafe();
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();

    private static Unsafe getUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e2) {
            throw new RuntimeException("Could not access the sun.misc.Unsafe handle, permission denied by security manager.", e2);
        }
        catch (NoSuchFieldException e3) {
            throw new RuntimeException("The static handle field in sun.misc.Unsafe was not found.");
        }
        catch (IllegalArgumentException e4) {
            throw new RuntimeException("Bug: Illegal argument reflection access for static field.", e4);
        }
        catch (IllegalAccessException e5) {
            throw new RuntimeException("Access to sun.misc.Unsafe is forbidden by the runtime.", e5);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unclassified error while trying to access the sun.misc.Unsafe handle.", t);
        }
    }

    private MemoryUtils() {
    }
}

