/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.dropwizard.metrics;

import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.flink.metrics.HistogramStatistics;

class HistogramStatisticsWrapper
extends Snapshot {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final HistogramStatistics histogramStatistics;

    HistogramStatisticsWrapper(HistogramStatistics histogramStatistics) {
        this.histogramStatistics = histogramStatistics;
    }

    public double getValue(double quantile) {
        return this.histogramStatistics.getQuantile(quantile);
    }

    public long[] getValues() {
        return this.histogramStatistics.getValues();
    }

    public int size() {
        return this.histogramStatistics.size();
    }

    public long getMax() {
        return this.histogramStatistics.getMax();
    }

    public double getMean() {
        return this.histogramStatistics.getMean();
    }

    public long getMin() {
        return this.histogramStatistics.getMin();
    }

    public double getStdDev() {
        return this.histogramStatistics.getStdDev();
    }

    public void dump(OutputStream output2) {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(output2, UTF_8));){
            long[] lArray = this.histogramStatistics.getValues();
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long value = lArray[i];
                printWriter.printf("%d%n", value);
            }
        }
    }
}

