/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.functions;

import java.io.IOException;
import org.apache.flink.api.common.functions.RichCoGroupFunction;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.api.streaming.data.PythonDualInputStreamer;
import org.apache.flink.util.Collector;

public class PythonCoGroup<IN1, IN2, OUT>
extends RichCoGroupFunction<IN1, IN2, OUT>
implements ResultTypeQueryable<OUT> {
    private static final long serialVersionUID = -3997396583317513873L;
    private final PythonDualInputStreamer<IN1, IN2, OUT> streamer;
    private final transient TypeInformation<OUT> typeInformation;

    public PythonCoGroup(Configuration config, int envID, int setID, TypeInformation<OUT> typeInformation) {
        this.typeInformation = typeInformation;
        this.streamer = new PythonDualInputStreamer(this, config, envID, setID, typeInformation instanceof PrimitiveArrayTypeInfo);
    }

    @Override
    public void open(Configuration config) throws IOException {
        this.streamer.open();
        this.streamer.sendBroadCastVariables(config);
    }

    @Override
    public final void coGroup(Iterable<IN1> first, Iterable<IN2> second, Collector<OUT> out) throws Exception {
        this.streamer.streamBufferWithGroups(first.iterator(), second.iterator(), out);
    }

    @Override
    public void close() throws IOException {
        this.streamer.close();
    }

    @Override
    public TypeInformation<OUT> getProducedType() {
        return this.typeInformation;
    }
}

