/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.data;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.api.streaming.data.PythonSender;
import org.apache.flink.python.api.streaming.data.SingleElementPushBackIterator;

public class PythonDualInputSender<IN1, IN2>
extends PythonSender {
    private static final long serialVersionUID = 614115041181108878L;
    private transient PythonSender.Serializer<IN1> serializer1;
    private transient PythonSender.Serializer<IN2> serializer2;

    protected PythonDualInputSender(Configuration config) {
        super(config);
    }

    public int sendBuffer1(SingleElementPushBackIterator<IN1> input) throws IOException {
        if (this.serializer1 == null) {
            IN1 value = input.next();
            this.serializer1 = this.getSerializer(value);
            input.pushBack(value);
        }
        return this.sendBuffer(input, this.serializer1);
    }

    public int sendBuffer2(SingleElementPushBackIterator<IN2> input) throws IOException {
        if (this.serializer2 == null) {
            IN2 value = input.next();
            this.serializer2 = this.getSerializer(value);
            input.pushBack(value);
        }
        return this.sendBuffer(input, this.serializer2);
    }
}

