/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.data;

import java.net.SocketTimeoutException;
import java.util.Iterator;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.api.streaming.data.PythonSingleInputSender;
import org.apache.flink.python.api.streaming.data.PythonStreamer;
import org.apache.flink.python.api.streaming.data.SingleElementPushBackIterator;
import org.apache.flink.util.Collector;

public class PythonSingleInputStreamer<IN, OUT>
extends PythonStreamer<PythonSingleInputSender<IN>, OUT> {
    private static final long serialVersionUID = -5149905918522069034L;

    public PythonSingleInputStreamer(AbstractRichFunction function, Configuration config, int envID, int setID, boolean usesByteArray) {
        super(function, config, envID, setID, usesByteArray, new PythonSingleInputSender(config));
    }

    public final void streamBufferWithoutGroups(Iterator<IN> iterator, Collector<OUT> c) {
        block14: {
            SingleElementPushBackIterator<IN> i = new SingleElementPushBackIterator<IN>(iterator);
            try {
                if (!i.hasNext()) break block14;
                block12: while (true) {
                    int sig = this.in.readInt();
                    switch (sig) {
                        case 0: {
                            if (i.hasNext()) {
                                int size = ((PythonSingleInputSender)this.sender).sendBuffer(i);
                                this.sendWriteNotification(size, i.hasNext());
                                continue block12;
                            }
                            throw new RuntimeException("External process requested data even though none is available.");
                        }
                        case -1: {
                            return;
                        }
                        case -2: {
                            try {
                                this.outPrinter.join();
                            }
                            catch (InterruptedException e2) {
                                this.outPrinter.interrupt();
                            }
                            try {
                                this.errorPrinter.join();
                            }
                            catch (InterruptedException e3) {
                                this.errorPrinter.interrupt();
                            }
                            throw new RuntimeException("External process for task " + this.function.getRuntimeContext().getTaskName() + " terminated prematurely due to an error." + this.msg);
                        }
                    }
                    this.receiver.collectBuffer(c, sig);
                    this.sendReadConfirmation();
                }
            }
            catch (SocketTimeoutException ignored) {
                throw new RuntimeException("External process for task " + this.function.getRuntimeContext().getTaskName() + " stopped responding." + (String)this.msg.get());
            }
            catch (Exception e4) {
                throw new RuntimeException("Critical failure for task " + this.function.getRuntimeContext().getTaskName() + ". " + (String)this.msg.get(), e4);
            }
        }
    }
}

