/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.plan;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.api.PythonOptions;
import org.apache.flink.python.api.PythonPlanBinder;
import org.apache.flink.python.api.streaming.plan.PythonPlanReceiver;
import org.apache.flink.python.api.streaming.plan.PythonPlanSender;
import org.apache.flink.python.api.streaming.util.StreamPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonPlanStreamer {
    protected static final Logger LOG = LoggerFactory.getLogger(PythonPlanStreamer.class);
    private final Configuration config;
    protected PythonPlanSender sender;
    protected PythonPlanReceiver receiver;
    private Process process;
    private ServerSocket server;
    private Socket socket;

    public PythonPlanStreamer(Configuration config) {
        this.config = config;
    }

    public Object getRecord() throws IOException {
        return this.getRecord(false);
    }

    public Object getRecord(boolean normalize) throws IOException {
        return this.receiver.getRecord(normalize);
    }

    public void sendRecord(Object record) throws IOException {
        this.sender.sendRecord(record);
    }

    public void open(String tmpPath, String args) throws IOException {
        this.startPython(tmpPath, args);
    }

    private void startPython(String tmpPath, String args) throws IOException {
        String pythonBinaryPath = this.config.getString(PythonOptions.PYTHON_BINARY_PATH);
        try {
            Runtime.getRuntime().exec(pythonBinaryPath);
        }
        catch (IOException ignored) {
            throw new RuntimeException(pythonBinaryPath + " does not point to a valid python binary.");
        }
        this.process = Runtime.getRuntime().exec(pythonBinaryPath + " -B " + tmpPath + PythonPlanBinder.FLINK_PYTHON_PLAN_NAME + args);
        new Thread(new StreamPrinter(this.process.getInputStream())).start();
        new Thread(new StreamPrinter(this.process.getErrorStream())).start();
        this.server = new ServerSocket(0);
        this.server.setSoTimeout(50);
        this.process.getOutputStream().write("plan\n".getBytes(ConfigConstants.DEFAULT_CHARSET));
        this.process.getOutputStream().flush();
    }

    public boolean preparePlanMode() throws IOException {
        try {
            this.process.getOutputStream().write((this.server.getLocalPort() + "\n").getBytes(ConfigConstants.DEFAULT_CHARSET));
            this.process.getOutputStream().flush();
        }
        catch (IOException ignored) {
            return false;
        }
        block9: while (true) {
            try {
                this.socket = this.server.accept();
                this.sender = new PythonPlanSender(this.socket.getOutputStream());
                this.receiver = new PythonPlanReceiver(this.socket.getInputStream());
                return true;
            }
            catch (SocketTimeoutException ignored) {
                switch (this.checkPythonProcessHealth()) {
                    case RUNNING: {
                        continue block9;
                    }
                    case STOPPED: {
                        return false;
                    }
                    case FAILED: {
                        throw new RuntimeException("Plan file caused an error. Check log-files for details.");
                    }
                }
                continue;
            }
            break;
        }
    }

    public void finishPlanMode() {
        try {
            this.socket.close();
        }
        catch (IOException e2) {
            LOG.error("Failed to close socket.", (Throwable)e2);
        }
    }

    public void close() {
        try {
            this.process.exitValue();
        }
        catch (NullPointerException e2) {
        }
        catch (IllegalThreadStateException ignored) {
            this.process.destroy();
        }
        finally {
            try {
                this.server.close();
            }
            catch (IOException e3) {
                LOG.error("Failed to close socket.", (Throwable)e3);
            }
        }
    }

    private ProcessState checkPythonProcessHealth() {
        try {
            int value = this.process.exitValue();
            if (value != 0) {
                return ProcessState.FAILED;
            }
            return ProcessState.STOPPED;
        }
        catch (IllegalThreadStateException ignored) {
            return ProcessState.RUNNING;
        }
    }

    private static enum ProcessState {
        RUNNING,
        FAILED,
        STOPPED;

    }
}

