/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.configuration.ConfigConstants;

public class StreamPrinter
implements Runnable {
    private final BufferedReader reader;
    private final AtomicReference<String> output;

    public StreamPrinter(InputStream stream) {
        this(stream, null);
    }

    public StreamPrinter(InputStream stream, AtomicReference<String> output2) {
        this.reader = new BufferedReader(new InputStreamReader(stream, ConfigConstants.DEFAULT_CHARSET));
        this.output = output2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.output != null) {
            StringBuilder msg = new StringBuilder();
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    msg.append(line);
                    msg.append("\n");
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.output.set(msg.toString());
            }
        } else {
            try {
                String line;
                while ((line = this.reader.readLine()) != null) {
                    System.out.println(line);
                    System.out.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

